% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlda_main.R
\name{vlda}
\alias{vlda}
\title{Visualization of Longitudinal Data Analysis}
\usage{
vlda(x, object, time, type = c("long", "wide"))
}
\arguments{
\item{x}{A data frame consisting of categorical data coded in numbers. Its \code{n} samples(\code{object}) should have been repeatedly measured through multiple time points; its \code{p} variables will be represented as variable coordinate. To keep track of which observation occurred in which time point, you must have included a variable, \code{Time}.}

\item{object}{A vector of length n samples. The \code{object} who would have made repeatedly measure through multiple time points; the object is indicated by the name of the observation coordinate.}

\item{time}{A time point of longitudinal data. Accepts a character string that denotes the name of the time variable.}

\item{type}{A type of longitudinal data.}
}
\value{
\item{obs.coordinate}{A tibble data class of row coordinates. Each row represents row coordinates and the observations corresponding to each row are included in the \code{obs_list}}
   \item{var.coordinate}{The column coordinate.}
   \item{Eigen}{Summarize the \code{principal inertias(Eigenvalues)} that as a result of applying the above algorithm using the indicator matrix}
   \item{GOF}{\code{Goodness-of-fit} of the Approximation for 2-dimensional VLDA plot.}
}
\description{
Visualization of multidimensional longitudinal data based on the projection method using the indicator matrix.
}
\details{
The value returned by vlda is using as the main argument of vlda_plot and vlda_add function, the corresponding model.
long-format is that each row is one time point per \code{object} So each \code{object} has \code{T} rows. All \code{T} values for each \code{object} are stacked–they're all in the one column; wide-format is that a \code{object} repeated responses will be in a single row, and each response is in a separate column. so \eqn{(Y_{1}, \ldots ,Y_{T})} are the response variables obtained at time \eqn{t(=1,\ldots ,T)}.\code{type = c(long, wide)}
}
\examples{
## longform of the PTSD data
data(PTSD)
PTSD <- as.data.frame(PTSD)
PTSD[,2:4] <- apply(PTSD[,2:4], 2, function(x) ifelse(x >= 3, 1, 0))
PTSD[,5] <-  ifelse(PTSD[,5] >= 6 , 1, 0)
PTSD <- data.frame(lapply(PTSD, function(x) as.factor(x)))
vlda(x = PTSD, object = "subject", time = "time", type = "long")


## Wideform od the Depression data
data(Depression)
head(Depression)
vlda(Depression, object = "Case", time = c("1week", "2weeks", "4weeks"), type = "wide")
vlda(Depression, "Case", c("1week", "2weeks", "4weeks"), "wide")

}
\seealso{
\code{vlda_add} \cr \code{vlda_plot}
}
\keyword{VLDA}
