% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eocusum_sim.R
\name{optimal_k}
\alias{optimal_k}
\title{Compute optimal k}
\usage{
optimal_k(QA, parsonnetscores, coeff)
}
\arguments{
\item{QA}{double. Defines the performance of a surgeon with the odds ratio ratio of death Q.}

\item{parsonnetscores}{NumericVector. Vector of Parsonnet Scores.}

\item{coeff}{NumericVector. Estimated coefficients \eqn{\alpha}{alpha} and \eqn{\beta}{beta}
from the binary logistic regression model. For more information see details.}
}
\value{
Returns a single value which is the approximate optimal k for a set of given Parsonnet scores.
}
\description{
Compute optimal k.
}
\details{
Formula deterioration:  \deqn{ k{det} = \frac{Q{A} - 1 - log(Q{A})}{log(Q{A})}\bar{p} , Q{A} > 1    }
         Formula improvement:    \deqn{ k{imp} = \frac{1 - Q{A} + log(Q{A})}{log(Q{A})}\bar{p} , Q{A} < 1    }
}
\examples{
library("vlad"); library("spcadjust")
data("cardiacsurgery")
cardiacsurgery <- dplyr::mutate(cardiacsurgery, phase=factor(ifelse(date < 2*365, "I", "II")))
S2I <- subset(cardiacsurgery, c(surgeon==2 & phase=="I"), c("Parsonnet", "status"))
coeff <- coef(glm(status ~ Parsonnet, data=S2I, family="binomial"))
kopt <- optimal_k(QA=2, parsonnetscores=S2I$Parsonnet, coeff=coeff)
kopt ## (Deterioration)
# manually find optimal k for detecting improvement
QA <- 2
pbar <- mean(sapply(S2I[, 1], gettherisk, coef=coeff))
kopt <- pbar * ( QA - 1 - log(QA) ) / log(QA)
all.equal(kopt, optimal_k(QA=2, parsonnetscores=S2I$Parsonnet, coeff=coeff) )
kopt <- optimal_k(QA=1/2, parsonnetscores=S2I$Parsonnet, coeff=coeff)
kopt ##(Improvement)
## k_opt = 0.02555328
### k = kopt
QA <- 1/2
# manually find optimal k for detecting improvement
pbar <- mean(sapply(S2I[, 1], gettherisk, coef=coeff))
kopt <- pbar * ( 1 - QA + log(QA) ) / log(QA)
all.equal(kopt, optimal_k(QA=1/2, parsonnetscores=S2I$Parsonnet, coeff=coeff) )
}
\author{
Philipp Wittenberg
}
