% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdpVars.R
\name{pdpVars}
\alias{pdpVars}
\title{pdpVars}
\usage{
pdpVars(
  data,
  fit,
  response,
  vars = NULL,
  pal = rev(RColorBrewer::brewer.pal(11, "RdYlBu")),
  gridSize = 10,
  nmax = 500,
  class = 1,
  nIce = 30,
  predictFun = NULL,
  limits = NULL,
  colorVar = NULL,
  draw = TRUE,
  probability = FALSE
)
}
\arguments{
\item{data}{Data frame used for fit.}

\item{fit}{A supervised machine learning model, which understands condvis2::CVpredict}

\item{response}{The name of the response for the fit.}

\item{vars}{The variables to plot (and their order), defaults to all variables other than response.}

\item{pal}{A vector of colors to show predictions, for use with scale_fill_gradientn}

\item{gridSize}{The size of the grid for evaluating the predictions.}

\item{nmax}{Uses sample of nmax data rows for the pdp.  Default is 500. Use all rows if NULL.}

\item{class}{Category for classification, a factor level, or a number indicating which factor level.}

\item{nIce}{Number of ice curves to be plotted, defaults to 30.}

\item{predictFun}{Function of (fit, data) to extract numeric predictions from fit. Uses condvis2::CVpredict by default, which works for many fit classes.}

\item{limits}{A vector determining the limits of the predicted values.}

\item{colorVar}{Which variable to colour the predictions by.}

\item{draw}{If FALSE, then the plot will not be drawn. Default is TRUE.}

\item{probability}{if TRUE, then returns the partial dependence for classification on the probability scale. If
FALSE (default), then the partial dependence is returned on a near logit scale.}
}
\value{
A grid displaying ICE curves and univariate partial dependence.
}
\description{
Displays the individual conditional expectation (ICE) curves and aggregated partial dependence
for each variable in a grid.
}
\examples{

\donttest{
# Load in the data:
aq <- na.omit(airquality)
fit <- lm(Ozone ~ ., data = aq)
pdpVars(aq, fit, "Ozone")

# Classification
library(ranger)
rfClassif <- ranger(Species ~ ., data = iris, probability = TRUE)
pdpVars(iris, rfClassif, "Species", class = 3)

pp <- pdpVars(iris, rfClassif, "Species", class = 2, draw = FALSE)
pp[[1]]
pdpVars(iris, rfClassif, "Species", class = 2, colorVar = "Species")
}
}
