% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.vivid.R
\name{as.data.frame.vivid}
\alias{as.data.frame.vivid}
\title{as.data.frame.vivid}
\usage{
\method{as.data.frame}{vivid}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{A matrix of class 'vivid' to be converted to a data frame.}

\item{row.names}{NULL or a character vector giving the row names for the data frame. Missing values are not allowed.}

\item{optional}{Logical. If TRUE, setting row names and converting column names (to syntactic names: see
make.names) is optional. Note that all of R's base package as.data.frame() methods use optional
only for column names treatment, basically with the meaning of data.frame(*, check.names = !optional). See also the make.names argument of the matrix method.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A data frame of Vimp and Vint values and their index from the vivid matrix.
}
\description{
Takes a matrix of class \code{vivid} and turn it into a data frame
containing variable names, Vimp and Vint values, and the row and column index from the original
matrix.
}
\examples{
 \donttest{
library(ranger)
aq <- na.omit(airquality)
aq <- aq[1:20,]# for speed
rF <- ranger(Ozone ~ ., data = aq, importance = "permutation")
myMat <- vivi(fit = rF, data = aq, response = "Ozone")
myDf <- as.data.frame(myMat)
myDf
}
}
