% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_itsa.R
\name{create_itsa}
\alias{create_itsa}
\title{Estimate an effect of intervention on every Viva Insights metric in input
file by applying single-group Interrupted Time-Series Analysis (ITSA)}
\usage{
create_itsa(
  data,
  metrics = NULL,
  before_start = NULL,
  before_end = NULL,
  after_start = NULL,
  after_end = NULL,
  ac_lags_max = 7,
  return = "table"
)
}
\arguments{
\item{data}{Person Query as a dataframe including date column named
\code{MetricDate}. This function assumes the data format is \verb{\%Y-\%m-\%d} as is
standard in a Viva Insights query output.}

\item{metrics}{A character vector containing the variable names to perform
the interrupted time series analysis for.}

\item{before_start}{String specifying the start date of the 'before'
time period in \verb{\%Y-\%m-\%d} format. The 'before' time period refers to the
period before the intervention (e.g. training program, re-org, shift to
remote work) occurs and bounded by \code{before_start} and \code{before_end}
parameters. Longer period increases likelihood of achieving more
statistically significant results. Defaults to earliest date in dataset. If
not provided, this defaults to the earliest date in the dataset.}

\item{before_end}{String specifying the end date of 'before' time
period in \verb{\%Y-\%m-\%d} format. If \code{NULL}, an error will be raised, as this
value is required.}

\item{after_start}{String specifying the start date of the 'after'
time period in \verb{\%Y-\%m-\%d} format. If \code{NULL}, this will default to the value
of \code{before_end}. The 'after' time period refers to the period after the
intervention occurs and is bounded by \code{after_start} and \code{after_end}
parameters. Longer periods increase the likelihood of achieving more
statistically significant results.}

\item{after_end}{String specifying the end date of the 'after' time
period in \verb{\%Y-\%m-\%d} format. Defaults to the latest date in the dataset.}

\item{ac_lags_max}{Numeric value specifying the maximum lag for the autocorrelation test.
The Ljung-Box test is used to check for autocorrelation in the model residuals
up to this specified number of lags. Higher values check for longer-term
dependencies in the time series data.}

\item{return}{String specifying what output to return. Defaults to "table".
Valid return options include:
\itemize{
\item \code{'plot'}: return a list of plots.
\item \code{'table'}: return data.frame with estimated models' coefficients and
their corresponding p-values You should look for significant p-values in
beta_2 to indicate an immediate treatment effect, and/or in beta_3 to
indicate a treatment effect over time
}}
}
\value{
When 'data' is passed to \code{return}, a data frame with the following columns:
\itemize{
\item \code{metric_name}: Name of the metric being analyzed.
\item \code{beta_2}: Coefficient for the immediate treatment effect.
\item \code{beta_3}: Coefficient for the treatment effect over time.
\item \code{beta_2_pvalue}: P-value for the immediate treatment effect.
\item \code{beta_3_pvalue}: P-value for the treatment effect over time.
\item \code{AR_flag}: Logical flag indicating whether autocorrelation was detected.
\item \code{error_warning}: Error or warning message if applicable.
}
}
\description{
r lifecycle::badge('experimental')

This function implements ITSA method described in the paper 'Conducting
interrupted time-series analysis for single- and multiple-group comparisons',
Ariel Linden, The Stata Journal (2015), 15, Number 2, pp. 480-500

This function further requires the installation of 'sandwich' and 'lmtest' in
order to work. These packages can be installed from CRAN using
\code{install.packages()}.
}
\details{
This function uses the additional package dependencies 'sandwich' and
'lmtest'. Please install these separately from CRAN prior to running the
function.

As of May 2022, the 'portes' package was archived from CRAN. The dependency
has since been removed and dependent functions \code{Ljungbox()} incorporated into
the \strong{wpa} package.
}
\examples{
\dontrun{
# Returns summary table
create_itsa(
  data = pq_data,
  metrics = c("Collaboration_span", "Internal_network_size"),
  before_end = "2024-07-01",
  after_start = "2024-07-01",
  ac_lags_max = 7,
  return = "table"
)

# Returns list of plots
plot_list <-
  create_itsa(
    data = pq_data,
    metrics = c("Collaboration_span", "Internal_network_size"),
    before_end = "2024-07-01",
    after_start = "2024-07-01",
    ac_lags_max = 7,
    return = "plot"
  )

# Extract a plot as an example
plot_list$Collaboration_span
}

}
\author{
Aleksey Ashikhmin \href{mailto:alashi@microsoft.com}{alashi@microsoft.com}
}
\concept{Flexible Input}
\concept{Interrupted Time-Series Analysis}
