% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vistla.R
\name{vistla}
\alias{vistla}
\alias{vistla.formula}
\alias{vistla.data.frame}
\alias{vistla.default}
\title{Influence path identification with the Vistla algorithm}
\usage{
vistla(x, ...)

\method{vistla}{formula}(formula, data, ..., yn)

\method{vistla}{data.frame}(x, y, ..., flow, iomin, targets, verbose = FALSE, yn = "Y", threads)

\method{vistla}{default}(x, ...)
}
\arguments{
\item{x}{data frame of predictors.}

\item{...}{pass-through arguments, ignored.}

\item{formula}{alternatively, formula describing the task, in a form \code{root~predictors}, which adheres to standard R behaviours.
Accepts \code{+} to add a predictor, \code{-} to omit one, and \code{.} to import whole \code{data}.
Use \code{\link{I}} to calculate new predictors.
When present in \code{data}, response is getting omitted from predictors.}

\item{data}{\code{data.frame} in context of which the formula will be executed; can be omitted when not using \code{.}.}

\item{yn}{name of the root (\code{Y} value), used in result pretty-printing and plots. Must be a single-element character vector.}

\item{y}{vistla tree root, a feature from which influence paths will be traced.}

\item{flow}{algorithm mode, specifying the iota function which gives local score to an edge of an edge graph. If in doubt, use the default, \code{"fromdown"}.}

\item{iomin}{score threshold below which path is not considered further. The higher value the less paths are generated, which also lowers the time taken by the function.
The default value of 0 turns of this filtering.
The same effect can be later achieved with the \code{\link{prune}} function.}

\item{targets}{a vector of target feature names.
If given, the algorithm will stop just after reaching the last of them, rather than after tracing all paths from the root.
The same effect can be later achieved with the \code{\link{prune}} function.}

\item{verbose}{when set to \code{TRUE}, turns on reporting of the algorithm progress.}

\item{threads}{number of threads to use. 
When missing or set to 0, uses all available cores.}
}
\value{
The tracing results represented as an object of a class \code{vistla}.
 Use \code{\link{paths}} and \code{\link{path_to}} functions to extract individual paths,
 \code{\link{branches}} to get the whole tree and \code{\link{mi_scores}} to get the basic score matrix.
}
\description{
Detects influence paths.
}
