% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ranges.R
\name{plot_ranges}
\alias{plot_ranges}
\title{Plot the ranges of a data frame}
\usage{
plot_ranges(data_orig, linewidth, showLabels, background_lines)
}
\arguments{
\item{data_orig}{the data frame to be plotted (ranges + events)}

\item{linewidth}{the width in pixel for the range lines}

\item{showLabels}{boolean, show labels on events or not}

\item{background_lines}{number of grey background lines to draw}
}
\value{
a list containing the plots for the groups in data
}
\description{
Plot the ranges of a data frame
}
\examples{
\dontrun{
plot_ranges(data.frame(event = 1:2, start = as.POSIXct(c(Sys.Date(), Sys.Date() + 10)),
                       end = as.POSIXct(c(Sys.Date()+10, Sys.Date() + 15)),
                       group = "", tooltip = "", col = "green", fontcol = "black",
                       subplot = 1, y = 1:2, labelPos = "center", label = 1:2),
            linewidth = 10, showLabels = TRUE, background_lines = 11)
}
}
