% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_analysis.R
\name{vtInterim}
\alias{vtInterim}
\title{Conduct interim analysis}
\usage{
vtInterim(cur.obs.y, prev.obs.y = NULL, prev.res = NULL,
  etas = c(0.1, 0.3), dec.cut = 0.65, priors = NULL,
  prob.mdl = c("NONPARA", "NONPARA+", "PARA", "PARA+"), seed = NULL,
  ...)
}
\arguments{
\item{cur.obs.y}{Observed data from the current level, which is a vector of
length 4. The numbers correspond to \code{obs.y} in \code{\link{vtPost}}.}

\item{prev.obs.y}{Observed data from previous levels, which has the same
structure as \code{obs.y} in \code{\link{vtPost}}.}

\item{prev.res}{Response rate from the next lower dose level, say, \eqn{l-1}.
This can be a scalar representing the mean of the response rate
\eqn{E(q^{(l-1)})}, or a vector of posterior samples of the response rate
\eqn{q^{(l-1)}}. For \eqn{l=1}, this value is set to \eqn{0}.}

\item{etas}{Vector of length 2 representing \eqn{(p_L, p_U)}. \eqn{p_L}: lower
bound of DLT risk, below which the current dose is considered absolutely
safe; \eqn{p_U}: upper bound of DLT risk above which the current dose is
considered too toxic}

\item{dec.cut}{Thresholds \eqn{C_1,C_2,C_3}. If the vector length is shorter
than \eqn{3}, it is repeated to have \eqn{3} elements. See
\code{\link{visit}} for details.}

\item{priors}{A class \code{VTPRIOR} object created by
\code{\link{vtPriorPar}} for \code{PARA} and \code{PARA+} model.}

\item{prob.mdl}{Option of the probability models:

\itemize{\item{NONPARA: }{non-parametric+ model}

 \item{NONPARA+: }{non-parametric model}

\item{PARA: }{partially parametric model}

\item{PARA+: }{partially parametric+ model} }

Default value is \code{NONPARA}. See \code{\link{visit}} for details.}

\item{seed}{Random seed}

\item{...}{Additional arguments for \code{\link{vtPost}}}
}
\value{
A class \code{VTDEC} list containing
\itemize{
\item{prob: }{Probabilities of each decision map region}
\item{region: }{The region selected based on the sequential procedure described in \code{\link{visit}} }
\item{ptox: }{Mean risk of DLT, \eqn{E(p^{(l)})}}
\item{pres: }{Mean immune response rate, \eqn{E(q^{(l)})}}
\item{con.prob: }{Conditional probabilities of each decision map region}
\item{prev.res: }{Function parameter}
\item{etas: }{Function parameter}
\item{dec.cut: }{Function parameter}
}
}
\description{
Conduct an interim analysis for determining dose escalation actions
}
\details{
Using data from previous levels and the current level to conduct Bayesian
analysis, get the decision map information and make decision about dose
escalation actions. The actions include stop the trial, escalate to the next
higher dose level, or enroll more patients in the current level. See \code{\link{visit}}
for details.
}
\examples{

etas       <- c(0.1, 0.3)
dec.cut    <- c(0.6,0.6,0.6)
cur.obs.y  <- c(3, 2, 1, 1)
prev.obs.y <- c(5, 2, 0, 0)
rst.inter  <- vtInterim(cur.obs.y,  prev.obs.y = prev.obs.y,
                        prob.mdl = "NONPARA", etas = etas,
                        dec.cut = dec.cut,
                        nsmp = 2000);

}
