% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_analysis.R
\name{vtDecMap}
\alias{vtDecMap}
\title{Obtain decision map information}
\usage{
vtDecMap(thetas, etas, prev.res = 0, dec.cut = 0.6)
}
\arguments{
\item{thetas}{Posterior samples of \eqn{\theta}, a class \code{VTPOST} matrix
generated by \code{\link{vtPost}}}

\item{etas}{Vector of length 2 representing \eqn{(p_L, p_U)}. \eqn{p_L}: lower
bound of DLT risk, below which the current dose is considered absolutely
safe; \eqn{p_U}: upper bound of DLT risk above which the current dose is
considered too toxic}

\item{prev.res}{Response rate from the next lower dose level, say, \eqn{l-1}.
This can be a scalar representing the mean of the response rate
\eqn{E(q^{(l-1)})}, or a vector of posterior samples of the response rate
\eqn{q^{(l-1)}}. For \eqn{l=1}, this value is set to \eqn{0}.}

\item{dec.cut}{Thresholds \eqn{C_1,C_2,C_3}. If the vector length is shorter
than \eqn{3}, it is repeated to have \eqn{3} elements. See
\code{\link{visit}} for details.}
}
\value{
A class \code{VTDEC} list. See the return value from \code{\link{vtInterim}}
for details.
}
\description{
Summarize the posterior distribution of \eqn{\theta^{(l)}_{00},
    \theta^{(l)}_{01}, \theta^{(l)}_{10}, \theta^{(l)}_{11}} and get
    information for making dose escalation decisions
}
\details{
This function summarizes the posterior distribution of the
    \eqn{\theta^{(l)}_{00}, \theta^{(l)}_{01}, \theta^{(l)}_{10},
    \theta^{(l)}_{11}} and sequentially get the conditional probabilities of
    each decision map region. See \code{\link{visit}} for details of the
    decision map regions.
}
\examples{
etas     <- c(0.1, 0.3)
dec.cut  <- c(0.6,0.6,0.6)
obs.y    <- rbind(c(5, 2, 0, 0))
rst.post <- vtPost(obs.y,  prob.mdl = "NONPARA", nsmp = 2000)
dec.map  <- vtDecMap(rst.post, etas = etas, dec.cut = dec.cut)

}
