% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openGraphCairo.R
\name{openGraphCairo}
\alias{openGraphCairo}
\title{Cairo wrapper function}
\usage{
openGraphCairo(
  width = 640,
  height = 480,
  fileName = NULL,
  type = NULL,
  fileDirectory = getwd(),
  pointsize = 12,
  bg = "transparent",
  canvas = "white",
  units = "px",
  dpi = 150
)
}
\arguments{
\item{width}{see \code{Cairo()}}

\item{height}{see \code{Cairo()}}

\item{fileName}{name of file to be created. Does not include both file
extension '.\code{type}' and file \code{filedirectory}. Default file name
'visstat_plot'.}

\item{type}{Supported output types are 'png', 'jpeg', 'pdf', 'svg', 'ps' and
'tiff'. See \code{Cairo()}}

\item{fileDirectory}{path of directory, where plot is stored. Default current
working directory.}

\item{pointsize}{see \code{Cairo()}}

\item{bg}{see \code{Cairo()}}

\item{canvas}{see \code{Cairo()}}

\item{units}{see \code{Cairo()}}

\item{dpi}{DPI used for the conversion of units to pixels. Default value 150.}
}
\value{
NULL, if no \code{type} is specified. Otherwise see \code{Cairo()}
}
\description{
Cairo wrapper function returning NULL if not \code{type} is specified
}
\details{
\code{openGraphCairo()} \code{Cairo()} wrapper function. Differences to
\code{Cairo:} a) prematurely ends the function call to \code{Cairo()}
returning NULL, if no output \code{type}  of types 'png', 'jpeg', 'pdf',
'svg', 'ps' or 'tiff' is provided. b) The \code{file} argument of the
underlying Cairo function is generated by
\code{file.path(fileDirectory,paste(fileName,'.', type, sep = ''))}.
}
\examples{

##  adapted from example in \code{Cairo()}
openGraphCairo(fileName = "normal_dist", type = "pdf", fileDirectory = tempdir())
plot(rnorm(4000), rnorm(4000), col = "#ff000018", pch = 19, cex = 2)
dev.off() # creates a file 'normal_dist.pdf' in the directory specified in fileDirectory
# ## remove the plot from fileDirectory
file.remove(file.path(tempdir(), "normal_dist.pdf"))
}
