% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_attrition.R
\name{get_attrition}
\alias{get_attrition}
\title{Generate cohort attrition table}
\usage{
get_attrition(data, criteria_descriptions, criteria_conditions,
subject_column_name)
}
\arguments{
\item{data}{Dataframe. It is used as the input data to count the subjects
that meets the criteria of interest}

\item{criteria_descriptions}{\code{character} It contains the descriptions
of the inclusion/exclusion criteria.
Each element of the vector corresponds to the description of each criterion.}

\item{criteria_conditions}{\code{character} It contains the corresponding
conditions of the criteria.
These conditions will be used in the table to compute the counts of the
subjects.}

\item{subject_column_name}{\code{character} The column name of the table that
contains the subject id.}
}
\value{
The counts and percentages of the remaining and excluded subjects
for each step of the cohort selection in a table format.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}
This is an experimental function that may be developed over time.

This function calculates the subjects counts excluded and included
for each step of the cohort selection process.
}
\details{
criteria_descriptions and criteria_conditions need to be of same length
}
\examples{
visR::get_attrition(adtte,
  criteria_descriptions =
    c(
      "1. Placebo Group", "2. Be 75 years of age or older.",
      "3. White", "4. Site 709"
    ),
  criteria_conditions = c(
    "TRTP=='Placebo'", "AGE>=75",
    "RACE=='WHITE'", "SITEID==709"
  ),
  subject_column_name = "USUBJID"
)
}
