% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_theme.R
\name{define_theme}
\alias{define_theme}
\title{Provides a simple wrapper for themes}
\usage{
define_theme(
  strata = NULL,
  fontsizes = NULL,
  fontfamily = "Helvetica",
  grid = FALSE,
  bg = "transparent",
  legend_position = NULL
)
}
\arguments{
\item{strata}{named list containing the different strata and name:colour value pairs}

\item{fontsizes}{named list containing the font sizes for different options}

\item{fontfamily}{string with the name of a supported font}

\item{grid}{boolean that specifies whether the major and minor grid should be drawn. The drawing of major and minor
gridlines can be manipulated separately by using a boolean indicator in a named \code{list} with elements \code{major}
and \code{minor}.}

\item{bg}{string defining the colour for the background of the plot}

\item{legend_position}{string defining the legend position. Valid options are NULL, 'top' 'bottom' 'right' 'left'}
}
\value{
Nested list with styling preferences for a ggplot object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function collects several lists if they are present. If absent, reasonable defaults are used.
When strata are not defined in the theme, they default to grey50 and will not be presented in the legend.
}
\examples{

theme <- visR::define_theme(
  strata = list("SEX" = list(
    "F" = "red",
    "M" = "blue"
  )),
  fontsizes = list(
    "axis" = 12,
    "ticks" = 10,
    "legend_title" = 10,
    "legend_text" = 8
  ),
  fontfamily = "Helvetica",
  grid = list(
    "major" = FALSE,
    "minor" = FALSE
  ),
  bg = "transparent",
  legend_position = "top"
)

}
