% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_risktable.R
\name{add_risktable}
\alias{add_risktable}
\alias{add_risktable.ggsurvfit}
\title{Add risk tables to visR plots through an S3 method}
\usage{
add_risktable(gg, ...)

\method{add_risktable}{ggsurvfit}(
  gg,
  times = NULL,
  statlist = c("n.risk"),
  label = "At risk",
  group = "strata",
  collapse = FALSE,
  ...
)
}
\arguments{
\item{gg}{visR plot of class \code{ggsurvfit}}

\item{...}{other arguments passed on to the method add_risktable}

\item{times}{Numeric vector indicating the times at which the risk set, censored subjects, events are calculated.}

\item{statlist}{Character vector indicating which summary data to present. Current choices are "n.risk" "n.event" "n.censor".
Default is "n.risk".}

\item{label}{Character vector with labels for the statlist. Default matches "n.risk" with "At risk", "n.event" with "Events" and "n.censor"
with "Censored".}

\item{group}{String indicating the grouping variable for the risk tables.
Current options are:
\itemize{
\item{"strata": groups the risk tables per stratum.
The \code{label} specifies the label within each risk table. The strata levels
are used for the titles of the risk tables. This is the default}
\item{"statlist": groups the risk tables per statlist.
The \code{label} specifies the title for each risk table. The strata levels
are used for labeling within each risk table.}
}
Default is "strata".}

\item{collapse}{Boolean, indicates whether to present the data overall.
Default is FALSE.}
}
\value{
Object of class \code{ggplot} with added risk table.
}
\description{
S3 method for adding risk tables to visR plots. The function has following workflow:
\itemize{
\item{
The risktables are calculated using \code{\link[visR]{get_risktable}}
}
\item{
The risktables are placed underneath visR plots using \code{\link[cowplot]{plot_grid}}
}
\item{
Both the initial visR plot as the individual risktables are stored as attribute \code{component}
in the final object to allow post-modification of the individual plots if desired
}
}
}
\examples{

## Display 2 risk tables, 1 per statlist
adtte \%>\%
  visR::estimate_KM(strata = "TRTP") \%>\%
  visR::visr() \%>\%
  visR::add_risktable( label = c("Subjects at Risk", "Censored")
                      ,statlist = c("n.risk", "n.censor")
                      ,group = "statlist"
                     )

## Display overall risk table at selected times
adtte \%>\%
  visR::estimate_KM(strata = "TRTP") \%>\%
  visR::visr() \%>\%
  visR::add_risktable( label = c("Subjects at Risk", "Censored")
                      ,statlist = c("n.risk", "n.censor")
                      ,collapse = TRUE
                      ,times = c(0,20,40,60)
                     )
                     
## Add risk set as specified times
adtte \%>\%
  visR::estimate_KM(strata = "TRTP") \%>\%
  visR::visr() \%>\%
  visR::add_risktable(times = c(0, 20, 40, 100,111, 200))

}
\seealso{
\code{\link[cowplot]{plot_grid}}
}
