% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_CI.R
\name{add_CI}
\alias{add_CI}
\alias{add_CI.ggsurvfit}
\title{Add confidence interval (CI) to visR object}
\usage{
add_CI(gg, ...)

\method{add_CI}{ggsurvfit}(gg, alpha = 0.1, style = "ribbon", linetype, ...)
}
\arguments{
\item{gg}{A ggplot created with visR}

\item{...}{other arguments passed on to the method to modify \code{\link[ggplot2]{geom_ribbon}}}

\item{alpha}{aesthetic of ggplot2 \code{\link[ggplot2]{geom_ribbon}}. Default is 0.1.}

\item{style}{aesthetic of ggplot2 \code{\link[ggplot2]{geom_ribbon}}. Default is "ribbon". An alternative option is "step" that uses a line to display interval bounds.}

\item{linetype}{aesthetic of ggplot2 \code{\link[ggplot2]{geom_ribbon}}.}
}
\value{
Pointwise confidence interval overlayed on a visR ggplot
}
\description{
Method to add pointwise confidence intervals to a an object
created by visR through an S3 method. The method is set up to use
the pipe \verb{\%>\%}. There are two options to display CI's, a "ribbon" or
as "step" lines.

No default method is available at the moment.
}
\examples{

library(visR)

# Estimate KM curves by treatment group 
survfit_object <- survival::survfit(data = adtte, survival::Surv(AVAL, 1-CNSR) ~ TRTP)

## plot without confidence intervals (CI)
p <- visR::visr(survfit_object) 
p

# add CI to plot with default settings
p \%>\% add_CI()

# change transparency of CI ribbon  
p \%>\% add_CI(alpha = 0.9, style = "ribbon")

# plot CI as a step line instead of ribbon
p \%>\% add_CI(alpha = 0.1, style = "step")

# change linetype of CI
p \%>\% add_CI(style = "step", linetype = 1)

}
