% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTable.R
\name{fxTable}
\alias{fxTable}
\title{Creates a flextable object from a dataframe}
\usage{
fxTable(
  x,
  delim = "\\n",
  style = "default",
  na = "-",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  groupColumn = NULL,
  groupNameCol = lifecycle::deprecated(),
  groupAsColumn = FALSE,
  groupNameAsColumn = lifecycle::deprecated(),
  groupOrder = NULL,
  colsToMergeRows = NULL
)
}
\arguments{
\item{x}{A dataframe.}

\item{delim}{Delimiter.}

\item{style}{Named list that specifies how to style the different parts of
the gt table. Accepted entries are: title, subtitle, header, header_name,
header_level, column_name, group_label, and body. Alternatively, use
"default" to get visOmopResults style, or NULL for flextable style.}

\item{na}{How to display missing values.}

\item{title}{Title of the table, or NULL for no title.}

\item{subtitle}{Subtitle of the table, or NULL for no subtitle.}

\item{caption}{Caption for the table, or NULL for no caption. Text in
markdown formatting style (e.g. \verb{*Your caption here*} for caption in
italics).}

\item{groupColumn}{Column to use as group labels.}

\item{groupNameCol}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This argument was
renamed to "groupColumn" for consistency throughout the package functions.}

\item{groupAsColumn}{Whether to display the group labels as a column
(TRUE) or rows (FALSE).}

\item{groupNameAsColumn}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This argument was
renamed to "groupAsColumn" for consistency with the argument "groupColumn".}

\item{groupOrder}{Order in which to display group labels.}

\item{colsToMergeRows}{Names of the columns to merge vertically
when consecutive row cells have identical values. Alternatively, use
"all_columns" to apply this merging to all columns, or use NULL to indicate
no merging.}
}
\value{
A flextable object.

A flextable object.
}
\description{
Creates a flextable object from a dataframe using a delimiter to span
the header, and allows to easily customise table style.
}
\examples{
mockSummarisedResult() |>
  formatEstimateValue(decimals = c(integer = 0, numeric = 1)) |>
  formatHeader(header = c("Study strata", "strata_name", "strata_level"),
               includeHeaderName = FALSE) |>
  fxTable(
    style = "default",
    na = "--",
    title = "fxTable example",
    subtitle = NULL,
    caption = NULL,
    groupColumn = "group_level",
    groupAsColumn = TRUE,
    groupOrder = c("cohort1", "cohort2"),
    colsToMergeRows = "all_columns"
 )

}
