% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTable.R
\name{fxTable}
\alias{fxTable}
\title{Creates a flextable object from a dataframe}
\usage{
fxTable(
  x,
  delim = "\\n",
  style = "default",
  na = "-",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  groupNameCol = NULL,
  groupNameAsColumn = FALSE,
  groupOrder = NULL,
  colsToMergeRows = NULL
)
}
\arguments{
\item{x}{A dataframe.}

\item{delim}{Delimiter.}

\item{style}{Named list that specifies how to style the different parts of
the gt table. Accepted entries are: title, subtitle, header, header_name,
header_level, column_name, group_label, and body. Alternatively, use
"default" to get visOmopResults style, or NULL for flextable style.}

\item{na}{How to display missing values.}

\item{title}{Title of the table, or NULL for no title.}

\item{subtitle}{Subtitle of the table, or NULL for no subtitle.}

\item{caption}{Caption for the table, or NULL for no caption. Text in
markdown formatting style (e.g. \verb{*Your caption here*} for caption in
italics).}

\item{groupNameCol}{Column to use as group labels.}

\item{groupNameAsColumn}{Whether to display the group labels as a column
(TRUE) or rows (FALSE).}

\item{groupOrder}{Order in which to display group labels.}

\item{colsToMergeRows}{Names of the columns to merge vertically
when consecutive row cells have identical values. Alternatively, use
"all_columns" to apply this merging to all columns, or use NULL to indicate
no merging.}
}
\value{
A flextable object.

A flextable object.
}
\description{
Creates a flextable object from a dataframe using a delimiter to span
the header, and allows to easily customise table style.
}
\examples{
mockSummarisedResult() |>
  formatEstimateValue(decimals = c(integer = 0, numeric = 1)) |>
  formatHeader(header = c("Study strata", "strata_name", "strata_level"),
               includeHeaderName = FALSE) |>
  fxTable(
    style = "default",
    na = "--",
    title = "fxTable example",
    subtitle = NULL,
    caption = NULL,
    groupNameCol = "group_level",
    groupNameAsColumn = TRUE,
    groupOrder = c("cohort1", "cohort2"),
    colsToMergeRows = "all_columns"
 )

}
