% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visClustering.R
\name{visClusteringByGroup}
\alias{visClusteringByGroup}
\title{Network visualization clustering options - by group}
\usage{
visClusteringByGroup(graph, groups)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{groups}{: Character/vector. groups we want to cluster}
}
\description{
Network visualization clustering options - by group.
}
\examples{

 
 nodes <- data.frame(id = 1:10, label = paste("Label", 1:10), 
   group = sample(c("A", "B"), 10, replace = TRUE))
 edges <- data.frame(from = c(2,5,10), to = c(1,2,10))

 visNetwork(nodes, edges, legend = TRUE) \%>\%
   visGroups(groupname = "A", color = "red", shape = "database") \%>\%
   visGroups(groupname = "B", color = "yellow", shape = "triangle") \%>\%
   visClusteringByGroup(groups = c("B"))
 
}

