% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewparam.R
\name{view.param}
\alias{view.param}
\title{Computing parameters for the \code{\link{view}} function}
\usage{
view.param(angular.res, method)
}
\arguments{
\item{angular.res}{the angular resolution of  slightline that will be used in the \code{\link{view}} funtion. Default = 10.}

\item{method}{in some cases, when no space is available to insert a new circle, a hole might remain after the sphere surface filling.
Two options are available to correct this issue. If \emph{method = 'fill'} the gap is filled with a portion of circle and a new diection
is added but its angle with the neighboring direction is lower than \emph{angular.res}. If \emph{method = 'regularize} (the default value)
the directions are corrected so that they all have a similar angle between them. If \emph{method = 'n'} no action is taken.}
}
\value{
a data.frame containing the parameters to use as input in the \code{\link{view}} function.
}
\description{
The \strong{view.param} function computes the parameters for the \code{\link{view}} function. Each line of the output is a direction corresponding
to a single slightline. The calibration is done by optimizing the filling of the surface of a sphere with circles, each direction being recorded as the 3D
polar coordinates of the circle center.
}
\note{
some existing parameters are already provided with the viewshed3d package with parameters for an angular resolution ranging from 1 to 10 : \link{param_1},
\link{param_2}, \link{param_3}, \link{param_4}, \link{param_5}, \link{param_6}, \link{param_7}, \link{param_8}, \link{param_9}, \link{param_10}.
}
\examples{
\donttest{
library(viewshed3d)

#- anglura.res = 40 is way to big. Just good for the example
param=view.param(angular.res = 40)

head(param)
}

}
