% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual_magnitude.R
\name{visual_magnitude}
\alias{visual_magnitude}
\title{visual_magnitude}
\usage{
visual_magnitude(viewshed, dsm)
}
\arguments{
\item{viewshed}{Viewshed object.}

\item{dsm}{Raster, the digital surface / elevation model}
}
\value{
SpatRaster
}
\description{
This function is still in progress.
Visual Magnitude quantifies the extent of a visible region
as perceived by an observer. It is derived from the surface's slope and
angle features, alongside the observer's relative distance from the area
(Chamberlain & Meitner).
}
\examples{
\donttest{
# Load a viewpoint
test_viewpoint <- sf::read_sf(system.file("test_viewpoint.shp", package = "viewscape"))
# load dsm raster
dsm <- terra::rast(system.file("test_dsm.tif", package ="viewscape"))
# Compute viewshed
viewshed <- viewscape::compute_viewshed(dsm = dsm,
                                        viewpoints = test_viewpoint,
                                        offset_viewpoint = 6)
# Compute visual magnitude
vm <- viewscape::visual_magnitude(viewshed, dsm)
}

}
\references{
Chamberlain, B. C., & Meitner, M. J. (2013).
A route-based visibility analysis for landscape management.
Landscape and Urban Planning, 111, 13-24.
}
\seealso{
\code{\link[=compute_viewshed]{compute_viewshed()}}
}
