% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare two data frames}
\usage{
compare(
  table_a,
  table_b,
  by,
  allow_both_NA = TRUE,
  coerce = TRUE,
  use_duckplyr = FALSE
)
}
\arguments{
\item{table_a}{A data frame}

\item{table_b}{A data frame}

\item{by}{<\code{\link[=versus_tidy_select]{tidy-select}}>. Selection of columns to use when matching rows between
\code{.data_a} and \code{.data_b}. Both data frames must be unique on \code{by}.}

\item{allow_both_NA}{Logical. If \code{TRUE} a missing value in both data frames is
considered as equal}

\item{coerce}{Logical. If \code{FALSE} only columns with the same class are compared.}

\item{use_duckplyr}{Logical. Run \code{as_duckplyr_df()} on input tables before
performing comparison. This is useful when the tables are large because it makes
the comparison faster. If TRUE, the outputs will also be duckplyr_df objects.}
}
\value{
\describe{
\item{\code{compare()}}{A list of data frames having the following elements:
\describe{
\item{tables}{
A data frame with one row per input table showing the number of rows
and columns in each.
}
\item{by}{
A data frame with one row per \code{by} column showing the class
of the column in each of the input tables.
}
\item{summ}{
A data frame with one row per column common to \code{table_a} and
\code{table_b} and columns "n_diffs" showing the number of values which
are different between the two tables, "class_a"/"class_b" the class of the
column in each table, and "value_diffs" a (nested) data frame showing
the the values in each table which are unequal and the \code{by} columns
}
\item{unmatched_cols}{
A data frame with one row per column which is in one input table but
not the other and columns "table": which table the column appears in,
"column": the name of the column, and "class": the class of the
column.
}
\item{unmatched_rows}{
A data frame which, for each row present in one input table but not
the other, contains the column "table" showing which table the row appears
in and the \code{by} columns for that row.
}
}
}
}
}
\description{
Compare two data frames
}
\examples{
compare(example_df_a, example_df_b, by = car)
}
