% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.versions.R
\name{available.versions}
\alias{available.versions}
\title{available.versions}
\usage{
available.versions(pkgs)
}
\arguments{
\item{pkgs}{character vector of the names of packages for which to query
available versions}
}
\value{
a list of dataframes, each giving the versions and publication dates
 for the corresponding elements of \code{pkgs} as well as whether they can be
 installed from MRAN
}
\description{
List all of the past versions of the named packages ever
 uploaded to CRAN (and therefore in the CRAN source archives), their
 publication dates and whether they can be installed from MRAN via
 \code{\link{install.versions}} or \code{\link{install.dates}}.
}
\examples{

\dontrun{

# available versions of checkpoint
available.versions('checkpoint')

# available versions of checkpoint and devtools
available.versions(c('checkpoint', 'devtools'))

}

}

