% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R
\name{embed}
\alias{embed}
\alias{embed_vimeo}
\alias{embed_youtube}
\alias{embed_user2016}
\alias{embed_user2017}
\alias{embed_channel9}
\title{Embed a video into an HTML document}
\usage{
embed_vimeo(id, width = 500, height = 281, frameborder = 0,
  allowfullscreen = TRUE, query = NULL, fragment = NULL)

embed_youtube(id, width = 420, height = 315, frameborder = 0,
  allowfullscreen = TRUE, query = NULL)

embed_user2016(id, width = 560, height = 315, frameborder = 0,
  allowfullscreen = TRUE)

embed_user2017(id, width = 560, height = 315, frameborder = 0,
  allowfullscreen = TRUE)

embed_channel9(id, width = 560, height = 315, frameborder = 0,
  allowfullscreen = TRUE)
}
\arguments{
\item{id}{character, identifier provided by the service}

\item{width}{numeric, width of iframe (px)}

\item{height}{numeric, height of iframe (px)}

\item{frameborder}{numeric, size of frame border (px)}

\item{allowfullscreen}{logical, indicates if to allow fullscreen}

\item{query}{list of items to include in url-query string}

\item{fragment}{character, string to include as url-fragment}
}
\value{
An embed object that prints an \code{htmltools::\link[htmltools]{tags}$iframe} element
}
\description{
These functions are used to embed video into your \strong{rmarkdown} html-documents,
or into your \strong{shiny} apps. There are functions to embed from
YouTube, Vimeo, and Microsoft Channel 9 (who host the UseR! 2016 videos).
}
\details{
These services allow you to customize a lot of things by specifying
an optional query string. The specification for the query string will differ
according to the service being used:

\describe{
  \item{YouTube}{\url{https://developers.google.com/youtube/player_parameters}}
  \item{Vimeo}{\url{https://developer.vimeo.com/player/embedding}}
  \item{Channel 9}{\url{https://channel9.msdn.com/Events/useR-international-R-User-conference/useR2016/Forty-years-of-S}
  (click the \emph{Embed} tab)}
}
}
\examples{
embed_youtube("dQw4w9WgXcQ")
embed_vimeo("45196609")
embed_user2016("Literate-Programming")
embed_user2017("Room-202-Lightning-Talks") \%>\% use_start_time("26m35s")

}
\seealso{
\code{\link{use_start_time}}
}
