% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_hot_td.R
\name{emis_hot_td}
\alias{emis_hot_td}
\title{Estimation of hot exhaust emissions with top-down approach}
\usage{
emis_hot_td(veh, lkm, ef, pro_month, params, verbose = FALSE, fortran = FALSE)
}
\arguments{
\item{veh}{"Vehicles" data-frame or spatial feature, where columns are the
age distribution of that vehicle. and rows each simple feature or region.}

\item{lkm}{Numeric; mileage by the age of use of each vehicle.}

\item{ef}{Numeric or data.frame; emission factors. When it is a data.frame
number of rows can be for each region, or also, each region repeated
along 12 months. For instance, if you have 10 regions the number
of rows of ef can also be 120 (10 * 120).
when you have emission factors that varies with month, see \code{\link{ef_china}}.}

\item{pro_month}{Numeric or data.frame; montly profile to distribuite annual mileage
in each month. When it is a data.frame, each region (row) can have a different
monthly profile.}

\item{params}{List of parameters; Add columns with information to returning data.frame}

\item{verbose}{Logical; To show more information}

\item{fortran}{Logical; to try the fortran calculation.}
}
\value{
Emissions data.frame
}
\description{
\code{\link{emis_hot_td}} estimates cld start emissions with
a top-down appraoch. This is, annual or monthly emissions or region.
Especifically, the emissions are esitmated for row of the simple feature (row
of the spatial feature).

In general was designed so that each simple feature is a region with
different average monthly temperature.
This funcion, as other in this package, adapts to the class of the input data.
providing flexibility to the user.
}
\examples{
\dontrun{
# Do not run
euros <- c("V", "V", "IV", "III", "II", "I", "PRE", "PRE")
efh <- ef_ldv_speed(v = "PC", t = "4S", cc = "<=1400", f = "G",
          eu = euros, p = "CO", speed = Speed(34))
lkm <- units::as_units(c(20:13), "km")*1000
veh <- age_ldv(1:10, agemax = 8)
system.time(
a <- emis_hot_td(veh = veh,
                lkm = lkm,
                ef = EmissionFactors(as.numeric(efh[, 1:8])),
                verbose = TRUE))
system.time(
a2 <- emis_hot_td(veh = veh,
                  lkm = lkm,
                  ef = EmissionFactors(as.numeric(efh[, 1:8])),
                  verbose = TRUE,
                  fortran = TRUE)) #emistd7f.f95
identical(a, a2)

# adding columns
emis_hot_td(veh = veh,
            lkm = lkm,
            ef = EmissionFactors(as.numeric(efh[, 1:8])),
            verbose = TRUE,
            params = list(paste0("data_", 1:10), "moredata"))

# monthly profile (numeric) with numeric ef
veh_month <- c(rep(8, 1), rep(10, 5), 9, rep(10, 5))
system.time(
aa <- emis_hot_td(veh = veh,
                  lkm = lkm,
                  ef = EmissionFactors(as.numeric(efh[, 1:8])),
                  pro_month = veh_month,
                  verbose = TRUE))
system.time(
aa2 <- emis_hot_td(veh = veh,
                  lkm = lkm,
                  ef = EmissionFactors(as.numeric(efh[, 1:8])),
                  pro_month = veh_month,
                  verbose = TRUE,
                  fortran = TRUE)) #emistd5f.f95
aa$emissions <- round(aa$emissions, 8)
aa2$emissions <- round(aa2$emissions, 8)
identical(aa, aa2)

# monthly profile (numeric) with data.frame ef
veh_month <- c(rep(8, 1), rep(10, 5), 9, rep(10, 5))
def <- matrix(EmissionFactors(as.numeric(efh[, 1:8])),
nrow = nrow(veh), ncol = ncol(veh), byrow = TRUE)
def <- EmissionFactors(def)
system.time(
aa <- emis_hot_td(veh = veh,
                  lkm = lkm,
                  ef = def,
                  pro_month = veh_month,
                  verbose = TRUE))
system.time(
aa2 <- emis_hot_td(veh = veh,
                  lkm = lkm,
                  ef = def,
                  pro_month = veh_month,
                  verbose = TRUE,
                  fortran = TRUE)) #emistd1f.f95
aa$emissions <- round(aa$emissions, 8)
aa2$emissions <- round(aa2$emissions, 8)
identical(aa, aa2)

# monthly profile (data.frame)
dfm <- matrix(c(rep(8, 1), rep(10, 5), 9, rep(10, 5)), nrow = 10, ncol = 12,
byrow = TRUE)
system.time(
aa <- emis_hot_td(veh = veh,
                  lkm = lkm,
                  ef = EmissionFactors(as.numeric(efh[, 1:8])),
                  pro_month = dfm,
                  verbose = TRUE))
system.time(
aa2 <- emis_hot_td(veh = veh,
                  lkm = lkm,
                  ef = EmissionFactors(as.numeric(efh[, 1:8])),
                  pro_month = dfm,
                  verbose = TRUE,
                  fortran = TRUE)) # emistd6f.f95
aa$emissions <- round(aa$emissions, 2)
aa2$emissions <- round(aa2$emissions, 2)
identical(aa, aa2)

# Suppose that we have a EmissionsFactor data.frame with number of rows for each month
# number of rows are 10 regions
# number of columns are 12 months
tem <- runif(n = 6*10, min = -10, max = 35)
temp <- c(rev(tem[order(tem)]), tem[order(tem)])
plot(temp)
dftemp <- celsius(matrix(temp, ncol = 12))
dfef <- ef_evap(ef = c(rep("eshotfi", 8)),
              v = "PC",
              cc = "<=1400",
              dt = dftemp,
              show = F,
              ca = "small",
              ltrip = units::set_units(10, km),
              pollutant = "NMHC")
dim(dfef) # 120 rows and 9 columns, 8 ef (g/km) and 1 for month
system.time(
aa <- emis_hot_td(veh = veh,
                  lkm = lkm,
                  ef = dfef,
                  pro_month = veh_month,
                  verbose = TRUE))
system.time(
aa2 <- emis_hot_td(veh = veh,
                   lkm = lkm,
                   ef = dfef,
                   pro_month = veh_month,
                   verbose = TRUE,
                   fortran = TRUE)) #emistd3f.f95
aa$emissions <- round(aa$emissions, 2)
aa2$emissions <- round(aa2$emissions, 2)
identical(aa, aa2)
plot(aggregate(aa$emissions, by = list(aa$month), sum)$x)

# Suppose that we have a EmissionsFactor data.frame with number of rows for each month
# monthly profile (data.frame)
system.time(
aa <- emis_hot_td(veh = veh,
                  lkm = lkm,
                  ef = dfef,
                  pro_month = dfm,
                  verbose = TRUE))
system.time(
aa2 <- emis_hot_td(veh = veh,
                   lkm = lkm,
                   ef = dfef,
                   pro_month = dfm,
                   verbose = TRUE,
                   fortran = TRUE)) #emistd4f.f95
aa$emissions <- round(aa$emissions, 8)
aa2$emissions <- round(aa2$emissions, 8)
identical(aa, aa2)
plot(aggregate(aa$emissions, by = list(aa$month), sum)$x)
}
}
\seealso{
\code{\link{ef_ldv_speed}} \code{\link{ef_china}}
}
