% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_grid.R
\name{emis_grid}
\alias{emis_grid}
\title{Allocate emissions into a grid}
\usage{
emis_grid(spobj, g, sr, type = "lines")
}
\arguments{
\item{spobj}{A spatial dataframe of class "sp" or "sf". When class is "sp"
it is transformed to "sf".}

\item{g}{A grid with class "SpatialPolygonsDataFrame" or "sf".}

\item{sr}{Spatial reference e.g: 31983. It is required if spobj and g are
not projected. Please, see http://spatialreference.org/.}

\item{type}{type of geometry: "lines" or "points".}
}
\description{
\code{\link{emis_grid}} allocates emissions proportionally to each grid
 cell. The process is performed by intersection between geometries and the grid.
It means that requires "sr" according with your location for the projection.
It is assumed that spobj is a Spatial*DataFrame or an "sf" with the pollutants
in data. This function returns an object of class "sf".
}
\note{
When spobj is a 'Spatial' object (class of sp), they are converted
 into 'sf'. Also, The aggregation of data is done with data.table functions.
}
\examples{
{
data(net)
g <- make_grid(net, 1/102.47/2) #500m in degrees
names(net)
netsf <- sf::st_as_sf(net)
netg <- emis_grid(spobj = netsf[, c("ldv", "hdv")], g = g, sr= 31983)
plot(netg["ldv"], axes = TRUE)
plot(netg["hdv"], axes = TRUE)
}
}
