% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speciate.R
\name{speciate}
\alias{speciate}
\title{Speciation of emissions}
\usage{
speciate(x, spec = "bcom", veh, fuel, eu, show = FALSE, list = FALSE)
}
\arguments{
\item{x}{Emissions estimation}

\item{spec}{type of speciation, e.g.: "bcom" stands for black carbon and
organic matter. The speciations are: "bcom", tyre", "break", "road","iag"
and "nox".}

\item{veh}{Type of vehicle. When spec is "bcom" or "nox" veh can be "PC",
"LCV", HDV" or "Motorcycle". When spec is "iag" veh is only "veh".
Not required for "tyre", "break" or "road"}

\item{fuel}{Fuel. When spec is "bcom" fuel can be "G" or "D".
When spec is "iag" fuel can be "G", "E" or "D". When spec is "nox" fuel can
be "G", "D", "LPG", "E85" or "CNG". Not required for "tyre", "break" or "road"}

\item{eu}{Euro emission standard: "PRE", "ECE_1501", "ECE_1502", "ECE_1503",
"I", "II", "III", "IV",  "V", "III-CDFP","IV-CDFP","V-CDFP", "III-ADFP",
"IV-ADFP","V-ADFP" and "OPEN_LOOP". When spec is "iag" accept the values
"Exhaust" "Evaporative" and "Liquid". When spec is "nox" eu can be
"PRE", "I", "II", "III", "IV", "V", "VI", "VIc", "III-DPF" or "III+CRT".
Not required for "tyre", "break" or "road"}

\item{show}{when TRUE shows row of table with respective speciation}

\item{list}{when TRUE returns a list with number of elements of the list as
the number species of pollutants}
}
\value{
dataframe of speciation in grams
}
\description{
The separation of emissions in different compunds. It includes
black carbon and organic matter from particulate matter. Soon it will be
added more speciations
}
\note{
when spec = "iag", veh is only "VEH", STANDARD is "Evaporative",
"Liquid" or "Exhaust", FUEL is "G" for gasoline (blended with 25\% ethanol),
 "E" for Ethanol and "D" for diesel (blended with 5\% of biodiesel).
 When spec = "bcom", veh can be "PC", "LCV", "Motorcycle" or "HDV"
  VEH", STANDARD is "Evaporative",
"Liquid" or "Exhaust", FUEL is "G" for gasoline (blended with 25\% ethanol),
 "E" for Ethanol and "D" for diesel (blended with 5\% of biodiesel).
}
\examples{
\dontrun{
# Do not run
pm <- rnorm(n = 100, mean = 400, sd = 2)
df <- speciate(pm, veh="PC", fuel="G", eu="I")
}
}
\references{
"bcom": Ntziachristos and Zamaras. 2016. Passneger cars, light
commercial trucks, heavy-duty vehicles including buses and motor cycles. In:
EEA, EMEP. EEA air pollutant emission inventory guidebook-2009. European
Environment Agency, Copenhagen, 2016

"tyre", "break" and "road": Ntziachristos and Boulter 2016.
Automobile tyre and break wear and road abrasion. In: EEA, EMEP. EEA air
pollutant emission inventory
guidebook-2009. European Environment Agency, Copenhagen, 2016

"iag": RAFEE, S.A.A. Estudo numerico do impacto das emissoes
veiculares e fixas da cidade de Manaus nas concentracoes de poluentes
atmosfericos da regiao amazonica. 2015. 109 f. Dissertacao (Mestrado).
Programa de Pos-Graduacao em Engenharia Ambiental (PPGEA) - Universidade
Tecnologica Federal do Parana. Londrina, 2015.
http://repositorio.utfpr.edu.br/jspui/bitstream/1/1675/1/LD_PPGEA_M_Rafee%2c%20Sameh%20Adib%20Abou_2015.pdf

"iag": Vela, A. L. V. Avaliacao do impacto da mudanca dos
fatores de emissao veicular na formacao de ozonio troposferico na Regiao
Metropolitana de Sao Paulo. 2013. Dissertacao de Mestrado. Instituto de
Astronomia, Geofisica e Ciencias Atmosfericas, Universidade de Sao Paulo,
Sao Paulo.
http://www.iag.usp.br/pos/sites/default/files/d_angel_l_v_vela_corrigida_0.pdf
}
