# vw_to_svg works with vega spec

    Code
      cat(spec_mtcars %>% vw_to_vega() %>% vw_to_svg())
    Output
      <?xml version="1.0" encoding="utf-8"?>
      <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" class="marks" width="392" height="347" viewBox="0 0 392 347"><rect width="392" height="347" fill="white"/><g fill="none" stroke-miterlimit="10" transform="translate(43,10)"><g class="mark-group role-frame root" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h300v300h-300Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,300.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(27,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(55,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(82,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(109,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(136,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(164,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(191,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(218,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(245,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(273,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(300,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,300)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,257)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,214)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,171)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,129)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,86)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,43)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,0)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'wt' for a linear scale with values from 0 to 6"><g transform="translate(0.5,300.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(27,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(55,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(82,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(109,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(136,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(164,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(191,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(218,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(245,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(273,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(300,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="start" transform="translate(0,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0.0</text><text text-anchor="middle" transform="translate(27.272727272727273,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">0.5</text><text text-anchor="middle" transform="translate(54.54545454545455,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">1.0</text><text text-anchor="middle" transform="translate(81.81818181818181,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">1.5</text><text text-anchor="middle" transform="translate(109.0909090909091,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">2.0</text><text text-anchor="middle" transform="translate(136.36363636363635,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">2.5</text><text text-anchor="middle" transform="translate(163.63636363636363,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">3.0</text><text text-anchor="middle" transform="translate(190.9090909090909,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">3.5</text><text text-anchor="middle" transform="translate(218.1818181818182,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4.0</text><text text-anchor="middle" transform="translate(245.45454545454547,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">4.5</text><text text-anchor="middle" transform="translate(272.7272727272727,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5.0</text><text text-anchor="end" transform="translate(300,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">5.5</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="300" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(150,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">wt</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="Y-axis titled 'mpg' for a linear scale with values from 0 to 35"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,300)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,257)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,214)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,171)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,129)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,86)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,43)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,0)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="end" transform="translate(-7,303)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0</text><text text-anchor="end" transform="translate(-7,260.14285714285717)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="end" transform="translate(-7,217.28571428571428)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="end" transform="translate(-7,174.42857142857142)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(-7,131.57142857142858)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text><text text-anchor="end" transform="translate(-7,88.71428571428571)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">25</text><text text-anchor="end" transform="translate(-7,45.85714285714287)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">30</text><text text-anchor="end" transform="translate(-7,3)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">35</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,300)" x2="0" y2="-300" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(-27,150) rotate(-90) translate(0,-2)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">mpg</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="wt: 2.62; mpg: 21; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(142.9090909090909,120)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.875; mpg: 21; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(156.8181818181818,120)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.32; mpg: 22.8; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(126.54545454545455,104.57142857142856)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.215; mpg: 21.4; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(175.36363636363635,116.57142857142857)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.44; mpg: 18.7; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(187.63636363636365,139.71428571428572)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.46; mpg: 18.1; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(188.72727272727272,144.85714285714283)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.57; mpg: 14.3; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(194.72727272727272,177.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.19; mpg: 24.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(174,90.85714285714288)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.15; mpg: 22.8; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(171.8181818181818,104.57142857142856)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.44; mpg: 19.2; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(187.63636363636365,135.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.44; mpg: 17.8; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(187.63636363636365,147.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 4.07; mpg: 16.4; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(222.00000000000003,159.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.73; mpg: 17.3; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(203.45454545454547,151.7142857142857)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.78; mpg: 15.2; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(206.1818181818182,169.71428571428572)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 5.25; mpg: 10.4; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(286.3636363636364,210.85714285714286)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 5.424; mpg: 10.4; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(295.8545454545455,210.85714285714286)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 5.345; mpg: 14.7; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(291.54545454545456,174.00000000000003)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.2; mpg: 32.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(120,22.285714285714285)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.615; mpg: 30.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(88.0909090909091,39.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.835; mpg: 33.9; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(100.09090909090908,9.428571428571441)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.465; mpg: 21.5; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(134.45454545454547,115.71428571428571)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.52; mpg: 15.5; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(192,167.14285714285714)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.435; mpg: 15.2; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(187.36363636363635,169.71428571428572)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.84; mpg: 13.3; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(209.45454545454544,186)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.845; mpg: 19.2; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(209.72727272727272,135.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.935; mpg: 27.3; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(105.54545454545455,65.99999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.14; mpg: 26; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(116.72727272727273,77.14285714285714)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.513; mpg: 30.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(82.52727272727272,39.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.17; mpg: 15.8; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(172.90909090909088,164.57142857142856)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.77; mpg: 19.7; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(151.0909090909091,131.14285714285714)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.57; mpg: 15; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(194.72727272727272,171.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.78; mpg: 21.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(151.63636363636363,116.57142857142857)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/></g><g class="mark-group role-legend" role="graphics-symbol" aria-roledescription="legend" aria-label="Symbol legend titled 'cyl' for stroke color with 3 values: 4, 6, 8"><g transform="translate(318,0)"><path class="background" aria-hidden="true" d="M0,0h26v61h-26Z" pointer-events="none"/><g><g class="mark-group role-legend-entry"><g transform="translate(0,16)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-group role-scope" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0,0h24v12.5h-24Z" pointer-events="none" opacity="1"/><g><g class="mark-symbol role-legend-symbol" pointer-events="none"><path transform="translate(6,6)" d="M5,0A5,5,0,1,1,-5,0A5,5,0,1,1,5,0" stroke="#4c78a8" stroke-width="1.5" opacity="0.7"/></g><g class="mark-text role-legend-label" pointer-events="none"><text text-anchor="start" transform="translate(16,9)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g><g transform="translate(0,16)"><path class="background" aria-hidden="true" d="M0,0h24v12.5h-24Z" pointer-events="none" opacity="1"/><g><g class="mark-symbol role-legend-symbol" pointer-events="none"><path transform="translate(6,6)" d="M5,0A5,5,0,1,1,-5,0A5,5,0,1,1,5,0" stroke="#f58518" stroke-width="1.5" opacity="0.7"/></g><g class="mark-text role-legend-label" pointer-events="none"><text text-anchor="start" transform="translate(16,9)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">6</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g><g transform="translate(0,32)"><path class="background" aria-hidden="true" d="M0,0h24v12.5h-24Z" pointer-events="none" opacity="1"/><g><g class="mark-symbol role-legend-symbol" pointer-events="none"><path transform="translate(6,6)" d="M5,0A5,5,0,1,1,-5,0A5,5,0,1,1,5,0" stroke="#e45756" stroke-width="1.5" opacity="0.7"/></g><g class="mark-text role-legend-label" pointer-events="none"><text text-anchor="start" transform="translate(16,9)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">8</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-text role-legend-title" pointer-events="none"><text text-anchor="start" transform="translate(0,9)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">cyl</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g></g></svg>

# vw_to_svg works with vega-lite spec

    Code
      cat(vw_to_svg(spec_mtcars))
    Output
      <?xml version="1.0" encoding="utf-8"?>
      <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" class="marks" width="392" height="347" viewBox="0 0 392 347"><rect width="392" height="347" fill="white"/><g fill="none" stroke-miterlimit="10" transform="translate(43,10)"><g class="mark-group role-frame root" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h300v300h-300Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,300.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(27,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(55,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(82,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(109,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(136,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(164,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(191,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(218,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(245,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(273,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(300,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,300)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,257)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,214)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,171)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,129)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,86)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,43)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,0)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'wt' for a linear scale with values from 0 to 6"><g transform="translate(0.5,300.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(27,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(55,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(82,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(109,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(136,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(164,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(191,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(218,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(245,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(273,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(300,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="start" transform="translate(0,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0.0</text><text text-anchor="middle" transform="translate(27.272727272727273,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">0.5</text><text text-anchor="middle" transform="translate(54.54545454545455,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">1.0</text><text text-anchor="middle" transform="translate(81.81818181818181,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">1.5</text><text text-anchor="middle" transform="translate(109.0909090909091,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">2.0</text><text text-anchor="middle" transform="translate(136.36363636363635,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">2.5</text><text text-anchor="middle" transform="translate(163.63636363636363,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">3.0</text><text text-anchor="middle" transform="translate(190.9090909090909,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">3.5</text><text text-anchor="middle" transform="translate(218.1818181818182,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4.0</text><text text-anchor="middle" transform="translate(245.45454545454547,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">4.5</text><text text-anchor="middle" transform="translate(272.7272727272727,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5.0</text><text text-anchor="end" transform="translate(300,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">5.5</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="300" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(150,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">wt</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="Y-axis titled 'mpg' for a linear scale with values from 0 to 35"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,300)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,257)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,214)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,171)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,129)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,86)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,43)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,0)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="end" transform="translate(-7,303)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0</text><text text-anchor="end" transform="translate(-7,260.14285714285717)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="end" transform="translate(-7,217.28571428571428)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="end" transform="translate(-7,174.42857142857142)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(-7,131.57142857142858)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text><text text-anchor="end" transform="translate(-7,88.71428571428571)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">25</text><text text-anchor="end" transform="translate(-7,45.85714285714287)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">30</text><text text-anchor="end" transform="translate(-7,3)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">35</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,300)" x2="0" y2="-300" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(-27,150) rotate(-90) translate(0,-2)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">mpg</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="wt: 2.62; mpg: 21; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(142.9090909090909,120)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.875; mpg: 21; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(156.8181818181818,120)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.32; mpg: 22.8; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(126.54545454545455,104.57142857142856)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.215; mpg: 21.4; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(175.36363636363635,116.57142857142857)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.44; mpg: 18.7; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(187.63636363636365,139.71428571428572)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.46; mpg: 18.1; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(188.72727272727272,144.85714285714283)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.57; mpg: 14.3; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(194.72727272727272,177.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.19; mpg: 24.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(174,90.85714285714288)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.15; mpg: 22.8; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(171.8181818181818,104.57142857142856)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.44; mpg: 19.2; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(187.63636363636365,135.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.44; mpg: 17.8; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(187.63636363636365,147.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 4.07; mpg: 16.4; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(222.00000000000003,159.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.73; mpg: 17.3; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(203.45454545454547,151.7142857142857)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.78; mpg: 15.2; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(206.1818181818182,169.71428571428572)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 5.25; mpg: 10.4; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(286.3636363636364,210.85714285714286)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 5.424; mpg: 10.4; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(295.8545454545455,210.85714285714286)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 5.345; mpg: 14.7; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(291.54545454545456,174.00000000000003)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.2; mpg: 32.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(120,22.285714285714285)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.615; mpg: 30.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(88.0909090909091,39.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.835; mpg: 33.9; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(100.09090909090908,9.428571428571441)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.465; mpg: 21.5; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(134.45454545454547,115.71428571428571)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.52; mpg: 15.5; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(192,167.14285714285714)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.435; mpg: 15.2; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(187.36363636363635,169.71428571428572)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.84; mpg: 13.3; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(209.45454545454544,186)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.845; mpg: 19.2; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(209.72727272727272,135.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.935; mpg: 27.3; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(105.54545454545455,65.99999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.14; mpg: 26; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(116.72727272727273,77.14285714285714)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.513; mpg: 30.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(82.52727272727272,39.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.17; mpg: 15.8; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(172.90909090909088,164.57142857142856)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.77; mpg: 19.7; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(151.0909090909091,131.14285714285714)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.57; mpg: 15; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(194.72727272727272,171.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.78; mpg: 21.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(151.63636363636363,116.57142857142857)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/></g><g class="mark-group role-legend" role="graphics-symbol" aria-roledescription="legend" aria-label="Symbol legend titled 'cyl' for stroke color with 3 values: 4, 6, 8"><g transform="translate(318,0)"><path class="background" aria-hidden="true" d="M0,0h26v61h-26Z" pointer-events="none"/><g><g class="mark-group role-legend-entry"><g transform="translate(0,16)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-group role-scope" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0,0h24v12.5h-24Z" pointer-events="none" opacity="1"/><g><g class="mark-symbol role-legend-symbol" pointer-events="none"><path transform="translate(6,6)" d="M5,0A5,5,0,1,1,-5,0A5,5,0,1,1,5,0" stroke="#4c78a8" stroke-width="1.5" opacity="0.7"/></g><g class="mark-text role-legend-label" pointer-events="none"><text text-anchor="start" transform="translate(16,9)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g><g transform="translate(0,16)"><path class="background" aria-hidden="true" d="M0,0h24v12.5h-24Z" pointer-events="none" opacity="1"/><g><g class="mark-symbol role-legend-symbol" pointer-events="none"><path transform="translate(6,6)" d="M5,0A5,5,0,1,1,-5,0A5,5,0,1,1,5,0" stroke="#f58518" stroke-width="1.5" opacity="0.7"/></g><g class="mark-text role-legend-label" pointer-events="none"><text text-anchor="start" transform="translate(16,9)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">6</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g><g transform="translate(0,32)"><path class="background" aria-hidden="true" d="M0,0h24v12.5h-24Z" pointer-events="none" opacity="1"/><g><g class="mark-symbol role-legend-symbol" pointer-events="none"><path transform="translate(6,6)" d="M5,0A5,5,0,1,1,-5,0A5,5,0,1,1,5,0" stroke="#e45756" stroke-width="1.5" opacity="0.7"/></g><g class="mark-text role-legend-label" pointer-events="none"><text text-anchor="start" transform="translate(16,9)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">8</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-text role-legend-title" pointer-events="none"><text text-anchor="start" transform="translate(0,9)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">cyl</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g></g></svg>

---

    Code
      cat(vw_to_svg(spec_mtcars4))
    Output
      <?xml version="1.0" encoding="utf-8"?>
      <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" class="marks" width="392" height="347" viewBox="0 0 392 347"><rect width="392" height="347" fill="white"/><g fill="none" stroke-miterlimit="10" transform="translate(43,10)"><g class="mark-group role-frame root" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h300v300h-300Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,300.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(27,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(55,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(82,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(109,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(136,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(164,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(191,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(218,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(245,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(273,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(300,-300)" x2="0" y2="300" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,300)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,257)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,214)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,171)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,129)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,86)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,43)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,0)" x2="300" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'wt' for a linear scale with values from 0 to 6"><g transform="translate(0.5,300.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(27,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(55,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(82,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(109,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(136,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(164,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(191,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(218,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(245,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(273,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(300,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="start" transform="translate(0,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0.0</text><text text-anchor="middle" transform="translate(27.272727272727273,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">0.5</text><text text-anchor="middle" transform="translate(54.54545454545455,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">1.0</text><text text-anchor="middle" transform="translate(81.81818181818181,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">1.5</text><text text-anchor="middle" transform="translate(109.0909090909091,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">2.0</text><text text-anchor="middle" transform="translate(136.36363636363635,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">2.5</text><text text-anchor="middle" transform="translate(163.63636363636363,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">3.0</text><text text-anchor="middle" transform="translate(190.9090909090909,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">3.5</text><text text-anchor="middle" transform="translate(218.1818181818182,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4.0</text><text text-anchor="middle" transform="translate(245.45454545454547,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">4.5</text><text text-anchor="middle" transform="translate(272.7272727272727,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5.0</text><text text-anchor="end" transform="translate(300,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="0">5.5</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="300" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(150,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">wt</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="Y-axis titled 'mpg' for a linear scale with values from 0 to 35"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,300)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,257)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,214)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,171)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,129)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,86)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,43)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,0)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="end" transform="translate(-7,303)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0</text><text text-anchor="end" transform="translate(-7,260.14285714285717)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="end" transform="translate(-7,217.28571428571428)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="end" transform="translate(-7,174.42857142857142)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(-7,131.57142857142858)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text><text text-anchor="end" transform="translate(-7,88.71428571428571)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">25</text><text text-anchor="end" transform="translate(-7,45.85714285714287)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">30</text><text text-anchor="end" transform="translate(-7,3)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">35</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,300)" x2="0" y2="-300" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(-27,150) rotate(-90) translate(0,-2)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">mpg</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="wt: 2.62; mpg: 21; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(142.9090909090909,120)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.875; mpg: 21; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(156.8181818181818,120)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.32; mpg: 22.8; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(126.54545454545455,104.57142857142856)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.215; mpg: 21.4; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(175.36363636363635,116.57142857142857)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.44; mpg: 18.7; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(187.63636363636365,139.71428571428572)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.46; mpg: 18.1; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(188.72727272727272,144.85714285714283)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.57; mpg: 14.3; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(194.72727272727272,177.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.19; mpg: 24.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(174,90.85714285714288)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.15; mpg: 22.8; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(171.8181818181818,104.57142857142856)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.44; mpg: 19.2; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(187.63636363636365,135.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.44; mpg: 17.8; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(187.63636363636365,147.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 4.07; mpg: 16.4; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(222.00000000000003,159.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.73; mpg: 17.3; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(203.45454545454547,151.7142857142857)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.78; mpg: 15.2; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(206.1818181818182,169.71428571428572)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 5.25; mpg: 10.4; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(286.3636363636364,210.85714285714286)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 5.424; mpg: 10.4; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(295.8545454545455,210.85714285714286)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 5.345; mpg: 14.7; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(291.54545454545456,174.00000000000003)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.2; mpg: 32.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(120,22.285714285714285)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.615; mpg: 30.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(88.0909090909091,39.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.835; mpg: 33.9; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(100.09090909090908,9.428571428571441)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.465; mpg: 21.5; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(134.45454545454547,115.71428571428571)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.52; mpg: 15.5; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(192,167.14285714285714)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.435; mpg: 15.2; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(187.36363636363635,169.71428571428572)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.84; mpg: 13.3; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(209.45454545454544,186)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.845; mpg: 19.2; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(209.72727272727272,135.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.935; mpg: 27.3; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(105.54545454545455,65.99999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.14; mpg: 26; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(116.72727272727273,77.14285714285714)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 1.513; mpg: 30.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(82.52727272727272,39.42857142857144)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.17; mpg: 15.8; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(172.90909090909088,164.57142857142856)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.77; mpg: 19.7; cyl: 6" role="graphics-symbol" aria-roledescription="point" transform="translate(151.0909090909091,131.14285714285714)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#f58518" stroke-width="2" opacity="0.7"/><path aria-label="wt: 3.57; mpg: 15; cyl: 8" role="graphics-symbol" aria-roledescription="point" transform="translate(194.72727272727272,171.42857142857142)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#e45756" stroke-width="2" opacity="0.7"/><path aria-label="wt: 2.78; mpg: 21.4; cyl: 4" role="graphics-symbol" aria-roledescription="point" transform="translate(151.63636363636363,116.57142857142857)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" stroke="#4c78a8" stroke-width="2" opacity="0.7"/></g><g class="mark-group role-legend" role="graphics-symbol" aria-roledescription="legend" aria-label="Symbol legend titled 'cyl' for stroke color with 3 values: 4, 6, 8"><g transform="translate(318,0)"><path class="background" aria-hidden="true" d="M0,0h26v61h-26Z" pointer-events="none"/><g><g class="mark-group role-legend-entry"><g transform="translate(0,16)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-group role-scope" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0,0h24v12.5h-24Z" pointer-events="none" opacity="1"/><g><g class="mark-symbol role-legend-symbol" pointer-events="none"><path transform="translate(6,6)" d="M5,0A5,5,0,1,1,-5,0A5,5,0,1,1,5,0" stroke="#4c78a8" stroke-width="1.5" opacity="0.7"/></g><g class="mark-text role-legend-label" pointer-events="none"><text text-anchor="start" transform="translate(16,9)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g><g transform="translate(0,16)"><path class="background" aria-hidden="true" d="M0,0h24v12.5h-24Z" pointer-events="none" opacity="1"/><g><g class="mark-symbol role-legend-symbol" pointer-events="none"><path transform="translate(6,6)" d="M5,0A5,5,0,1,1,-5,0A5,5,0,1,1,5,0" stroke="#f58518" stroke-width="1.5" opacity="0.7"/></g><g class="mark-text role-legend-label" pointer-events="none"><text text-anchor="start" transform="translate(16,9)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">6</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g><g transform="translate(0,32)"><path class="background" aria-hidden="true" d="M0,0h24v12.5h-24Z" pointer-events="none" opacity="1"/><g><g class="mark-symbol role-legend-symbol" pointer-events="none"><path transform="translate(6,6)" d="M5,0A5,5,0,1,1,-5,0A5,5,0,1,1,5,0" stroke="#e45756" stroke-width="1.5" opacity="0.7"/></g><g class="mark-text role-legend-label" pointer-events="none"><text text-anchor="start" transform="translate(16,9)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">8</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-text role-legend-title" pointer-events="none"><text text-anchor="start" transform="translate(0,9)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">cyl</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g></g></svg>

# vw_to_svg works with url data

    Code
      cat(vw_to_svg(spec_anscombe, base_url = base_url))
    Output
      <?xml version="1.0" encoding="utf-8"?>
      <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" class="marks" width="928" height="296" viewBox="0 0 928 296"><rect width="928" height="296" fill="white"/><g fill="none" stroke-miterlimit="10" transform="translate(47,57)"><g class="mark-group role-frame root" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z"/><g><g class="mark-group role-column-title column-title" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(436,-31)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z"/><g><g class="mark-group role-title"><g transform="translate(0,-21)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'Series'" pointer-events="none"><text text-anchor="middle" transform="translate(0,9)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">Series</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g><g class="mark-group role-row-header row_header" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(-4,0)"><path class="background" aria-hidden="true" d="M0,0h0v200h0Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="Y-axis titled 'Y' for a linear scale with values from 3 to 13"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,180)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="end" transform="translate(-7,183)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4</text><text text-anchor="end" transform="translate(-7,143)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">6</text><text text-anchor="end" transform="translate(-7,103)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">8</text><text text-anchor="end" transform="translate(-7,63.00000000000001)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="end" transform="translate(-7,22.999999999999996)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">12</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,200)" x2="0" y2="-200" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(-27,100) rotate(-90) translate(0,-2)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">Y</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g><g class="mark-group role-column-header column_header" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,-1)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-title"><g transform="translate(100,-20)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'I'" pointer-events="none"><text text-anchor="middle" transform="translate(0,8)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">I</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(225,-1)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-title"><g transform="translate(100,-20)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'II'" pointer-events="none"><text text-anchor="middle" transform="translate(0,8)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">II</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(450,-1)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-title"><g transform="translate(100,-20)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'III'" pointer-events="none"><text text-anchor="middle" transform="translate(0,8)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">III</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(675,-1)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-title"><g transform="translate(100,-20)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'IV'" pointer-events="none"><text text-anchor="middle" transform="translate(0,8)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">IV</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g><g class="mark-group role-column-footer column_footer" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,202)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'X' for a linear scale with values from 4 to 20"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(13,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(75,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(138,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(200,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="middle" transform="translate(12.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="middle" transform="translate(75,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="middle" transform="translate(137.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(200,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">X</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(225,202)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'X' for a linear scale with values from 4 to 20"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(13,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(75,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(138,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(200,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="middle" transform="translate(12.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="middle" transform="translate(75,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="middle" transform="translate(137.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(200,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">X</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(450,202)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'X' for a linear scale with values from 4 to 20"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(13,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(75,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(138,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(200,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="middle" transform="translate(12.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="middle" transform="translate(75,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="middle" transform="translate(137.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(200,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">X</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(675,202)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'X' for a linear scale with values from 4 to 20"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(13,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(75,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(138,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(200,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="middle" transform="translate(12.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="middle" transform="translate(75,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="middle" transform="translate(137.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(200,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">X</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g><g class="mark-group role-scope cell" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(13,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(75,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(138,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(200,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,180)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark child_marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="X: 10; Y: 8.04" role="graphics-symbol" aria-roledescription="circle" transform="translate(75,99.20000000000002)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 6.95" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,121)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 13; Y: 7.58" role="graphics-symbol" aria-roledescription="circle" transform="translate(112.5,108.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 9; Y: 8.81" role="graphics-symbol" aria-roledescription="circle" transform="translate(62.5,83.79999999999998)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 11; Y: 8.33" role="graphics-symbol" aria-roledescription="circle" transform="translate(87.5,93.39999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 14; Y: 9.96" role="graphics-symbol" aria-roledescription="circle" transform="translate(125,60.79999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 6; Y: 7.24" role="graphics-symbol" aria-roledescription="circle" transform="translate(25,115.19999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 4; Y: 4.26" role="graphics-symbol" aria-roledescription="circle" transform="translate(0,174.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 12; Y: 10.84" role="graphics-symbol" aria-roledescription="circle" transform="translate(100,43.199999999999996)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 7; Y: 4.81" role="graphics-symbol" aria-roledescription="circle" transform="translate(37.5,163.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 5; Y: 5.68" role="graphics-symbol" aria-roledescription="circle" transform="translate(12.5,146.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(225,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(13,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(75,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(138,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(200,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,180)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark child_marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="X: 10; Y: 9.14" role="graphics-symbol" aria-roledescription="circle" transform="translate(75,77.19999999999997)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 8.14" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,97.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 13; Y: 8.74" role="graphics-symbol" aria-roledescription="circle" transform="translate(112.5,85.19999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 9; Y: 8.77" role="graphics-symbol" aria-roledescription="circle" transform="translate(62.5,84.60000000000001)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 11; Y: 9.26" role="graphics-symbol" aria-roledescription="circle" transform="translate(87.5,74.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 14; Y: 8.1" role="graphics-symbol" aria-roledescription="circle" transform="translate(125,98)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 6; Y: 6.13" role="graphics-symbol" aria-roledescription="circle" transform="translate(25,137.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 4; Y: 3.1" role="graphics-symbol" aria-roledescription="circle" transform="translate(0,198)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 12; Y: 9.13" role="graphics-symbol" aria-roledescription="circle" transform="translate(100,77.39999999999998)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 7; Y: 7.26" role="graphics-symbol" aria-roledescription="circle" transform="translate(37.5,114.80000000000001)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 5; Y: 4.74" role="graphics-symbol" aria-roledescription="circle" transform="translate(12.5,165.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(450,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(13,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(75,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(138,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(200,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,180)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark child_marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="X: 10; Y: 7.46" role="graphics-symbol" aria-roledescription="circle" transform="translate(75,110.80000000000001)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 6.77" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,124.6)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 13; Y: 12.74" role="graphics-symbol" aria-roledescription="circle" transform="translate(112.5,5.200000000000005)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 9; Y: 7.11" role="graphics-symbol" aria-roledescription="circle" transform="translate(62.5,117.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 11; Y: 7.81" role="graphics-symbol" aria-roledescription="circle" transform="translate(87.5,103.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 14; Y: 8.84" role="graphics-symbol" aria-roledescription="circle" transform="translate(125,83.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 6; Y: 6.08" role="graphics-symbol" aria-roledescription="circle" transform="translate(25,138.39999999999998)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 4; Y: 5.39" role="graphics-symbol" aria-roledescription="circle" transform="translate(0,152.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 12; Y: 8.15" role="graphics-symbol" aria-roledescription="circle" transform="translate(100,97)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 7; Y: 6.42" role="graphics-symbol" aria-roledescription="circle" transform="translate(37.5,131.6)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 5; Y: 5.73" role="graphics-symbol" aria-roledescription="circle" transform="translate(12.5,145.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(675,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(13,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(75,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(138,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(200,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,180)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark child_marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="X: 8; Y: 6.58" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,128.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 5.76" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,144.79999999999998)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 7.71" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,105.80000000000001)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 8.84" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,83.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 8.47" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,90.6)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 7.04" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,119.19999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 5.25" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,155)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 19; Y: 12.5" role="graphics-symbol" aria-roledescription="circle" transform="translate(187.5,10.000000000000009)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 5.56" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,148.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 7.91" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,101.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 6.89" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,122.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g></g></svg>

---

    Code
      cat(vw_to_svg(spec_wx, base_url = base_url))
    Output
      <?xml version="1.0" encoding="utf-8"?>
      <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" class="marks" width="256" height="245" viewBox="0 0 256 245"><rect width="256" height="245" fill="white"/><g fill="none" stroke-miterlimit="10" transform="translate(51,8)"><g class="mark-group role-frame root" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(44,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(89,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(133,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(178,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,200)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,155)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,109)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,64)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,18)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'temp_max' for a linear scale with values from 0 to 5"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(44,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(89,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(133,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(178,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="start" transform="translate(0,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0</text><text text-anchor="middle" transform="translate(44.44444444444444,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">1</text><text text-anchor="middle" transform="translate(88.88888888888889,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">2</text><text text-anchor="middle" transform="translate(133.33333333333331,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">3</text><text text-anchor="middle" transform="translate(177.77777777777777,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">temp_max</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="Y-axis titled 'temp_min' for a linear scale with values from 0.0 to 2.2"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,200)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,155)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,109)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,64)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,18)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="end" transform="translate(-7,203)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0.0</text><text text-anchor="end" transform="translate(-7,157.54545454545453)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0.5</text><text text-anchor="end" transform="translate(-7,112.09090909090908)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">1.0</text><text text-anchor="end" transform="translate(-7,66.63636363636365)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">1.5</text><text text-anchor="end" transform="translate(-7,21.181818181818187)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">2.0</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,200)" x2="0" y2="-200" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(-35,100) rotate(-90) translate(0,-2)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">temp_min</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="temp_max: 4.4; temp_min: 2.2" role="graphics-symbol" aria-roledescription="circle" transform="translate(195.55555555555557,0)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="temp_max: 4.4; temp_min: 0.6" role="graphics-symbol" aria-roledescription="circle" transform="translate(195.55555555555557,145.45454545454547)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="temp_max: 4.4; temp_min: 0.6" role="graphics-symbol" aria-roledescription="circle" transform="translate(195.55555555555557,145.45454545454547)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="temp_max: 3.9; temp_min: 0.6" role="graphics-symbol" aria-roledescription="circle" transform="translate(173.33333333333334,145.45454545454547)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="temp_max: 4.4; temp_min: 1.7" role="graphics-symbol" aria-roledescription="circle" transform="translate(195.55555555555557,45.45454545454548)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g></g></svg>

# vw_to_svg works with local data

    Code
      cat(vw_to_svg(spec_anscombe, base_url = tempdir))
    Output
      <?xml version="1.0" encoding="utf-8"?>
      <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" class="marks" width="928" height="296" viewBox="0 0 928 296"><rect width="928" height="296" fill="white"/><g fill="none" stroke-miterlimit="10" transform="translate(47,57)"><g class="mark-group role-frame root" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z"/><g><g class="mark-group role-column-title column-title" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(436,-31)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z"/><g><g class="mark-group role-title"><g transform="translate(0,-21)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'Series'" pointer-events="none"><text text-anchor="middle" transform="translate(0,9)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">Series</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g><g class="mark-group role-row-header row_header" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(-4,0)"><path class="background" aria-hidden="true" d="M0,0h0v200h0Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="Y-axis titled 'Y' for a linear scale with values from 3 to 13"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,180)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="end" transform="translate(-7,183)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4</text><text text-anchor="end" transform="translate(-7,143)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">6</text><text text-anchor="end" transform="translate(-7,103)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">8</text><text text-anchor="end" transform="translate(-7,63.00000000000001)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="end" transform="translate(-7,22.999999999999996)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">12</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,200)" x2="0" y2="-200" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(-27,100) rotate(-90) translate(0,-2)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">Y</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g><g class="mark-group role-column-header column_header" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,-1)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-title"><g transform="translate(100,-20)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'I'" pointer-events="none"><text text-anchor="middle" transform="translate(0,8)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">I</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(225,-1)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-title"><g transform="translate(100,-20)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'II'" pointer-events="none"><text text-anchor="middle" transform="translate(0,8)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">II</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(450,-1)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-title"><g transform="translate(100,-20)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'III'" pointer-events="none"><text text-anchor="middle" transform="translate(0,8)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">III</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(675,-1)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-title"><g transform="translate(100,-20)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-text role-title-text" role="graphics-symbol" aria-roledescription="title" aria-label="Title text 'IV'" pointer-events="none"><text text-anchor="middle" transform="translate(0,8)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">IV</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g><g class="mark-group role-column-footer column_footer" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,202)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'X' for a linear scale with values from 4 to 20"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(13,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(75,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(138,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(200,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="middle" transform="translate(12.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="middle" transform="translate(75,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="middle" transform="translate(137.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(200,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">X</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(225,202)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'X' for a linear scale with values from 4 to 20"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(13,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(75,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(138,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(200,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="middle" transform="translate(12.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="middle" transform="translate(75,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="middle" transform="translate(137.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(200,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">X</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(450,202)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'X' for a linear scale with values from 4 to 20"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(13,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(75,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(138,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(200,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="middle" transform="translate(12.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="middle" transform="translate(75,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="middle" transform="translate(137.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(200,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">X</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(675,202)"><path class="background" aria-hidden="true" d="M0,0h200v0h-200Z"/><g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'X' for a linear scale with values from 4 to 20"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(13,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(75,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(138,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(200,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="middle" transform="translate(12.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">5</text><text text-anchor="middle" transform="translate(75,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">10</text><text text-anchor="middle" transform="translate(137.5,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">15</text><text text-anchor="end" transform="translate(200,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">20</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">X</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g><g class="mark-group role-scope cell" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(13,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(75,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(138,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(200,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,180)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark child_marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="X: 10; Y: 8.04" role="graphics-symbol" aria-roledescription="circle" transform="translate(75,99.20000000000002)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 6.95" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,121)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 13; Y: 7.58" role="graphics-symbol" aria-roledescription="circle" transform="translate(112.5,108.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 9; Y: 8.81" role="graphics-symbol" aria-roledescription="circle" transform="translate(62.5,83.79999999999998)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 11; Y: 8.33" role="graphics-symbol" aria-roledescription="circle" transform="translate(87.5,93.39999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 14; Y: 9.96" role="graphics-symbol" aria-roledescription="circle" transform="translate(125,60.79999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 6; Y: 7.24" role="graphics-symbol" aria-roledescription="circle" transform="translate(25,115.19999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 4; Y: 4.26" role="graphics-symbol" aria-roledescription="circle" transform="translate(0,174.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 12; Y: 10.84" role="graphics-symbol" aria-roledescription="circle" transform="translate(100,43.199999999999996)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 7; Y: 4.81" role="graphics-symbol" aria-roledescription="circle" transform="translate(37.5,163.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 5; Y: 5.68" role="graphics-symbol" aria-roledescription="circle" transform="translate(12.5,146.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(225,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(13,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(75,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(138,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(200,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,180)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark child_marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="X: 10; Y: 9.14" role="graphics-symbol" aria-roledescription="circle" transform="translate(75,77.19999999999997)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 8.14" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,97.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 13; Y: 8.74" role="graphics-symbol" aria-roledescription="circle" transform="translate(112.5,85.19999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 9; Y: 8.77" role="graphics-symbol" aria-roledescription="circle" transform="translate(62.5,84.60000000000001)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 11; Y: 9.26" role="graphics-symbol" aria-roledescription="circle" transform="translate(87.5,74.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 14; Y: 8.1" role="graphics-symbol" aria-roledescription="circle" transform="translate(125,98)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 6; Y: 6.13" role="graphics-symbol" aria-roledescription="circle" transform="translate(25,137.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 4; Y: 3.1" role="graphics-symbol" aria-roledescription="circle" transform="translate(0,198)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 12; Y: 9.13" role="graphics-symbol" aria-roledescription="circle" transform="translate(100,77.39999999999998)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 7; Y: 7.26" role="graphics-symbol" aria-roledescription="circle" transform="translate(37.5,114.80000000000001)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 5; Y: 4.74" role="graphics-symbol" aria-roledescription="circle" transform="translate(12.5,165.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(450,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(13,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(75,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(138,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(200,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,180)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark child_marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="X: 10; Y: 7.46" role="graphics-symbol" aria-roledescription="circle" transform="translate(75,110.80000000000001)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 6.77" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,124.6)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 13; Y: 12.74" role="graphics-symbol" aria-roledescription="circle" transform="translate(112.5,5.200000000000005)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 9; Y: 7.11" role="graphics-symbol" aria-roledescription="circle" transform="translate(62.5,117.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 11; Y: 7.81" role="graphics-symbol" aria-roledescription="circle" transform="translate(87.5,103.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 14; Y: 8.84" role="graphics-symbol" aria-roledescription="circle" transform="translate(125,83.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 6; Y: 6.08" role="graphics-symbol" aria-roledescription="circle" transform="translate(25,138.39999999999998)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 4; Y: 5.39" role="graphics-symbol" aria-roledescription="circle" transform="translate(0,152.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 12; Y: 8.15" role="graphics-symbol" aria-roledescription="circle" transform="translate(100,97)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 7; Y: 6.42" role="graphics-symbol" aria-roledescription="circle" transform="translate(37.5,131.6)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 5; Y: 5.73" role="graphics-symbol" aria-roledescription="circle" transform="translate(12.5,145.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g><g transform="translate(675,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(13,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(75,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(138,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(200,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,180)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,140)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,100)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,60)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,20)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark child_marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="X: 8; Y: 6.58" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,128.4)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 5.76" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,144.79999999999998)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 7.71" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,105.80000000000001)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 8.84" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,83.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 8.47" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,90.6)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 7.04" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,119.19999999999999)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 5.25" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,155)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 19; Y: 12.5" role="graphics-symbol" aria-roledescription="circle" transform="translate(187.5,10.000000000000009)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 5.56" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,148.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 7.91" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,101.8)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/><path aria-label="X: 8; Y: 6.89" role="graphics-symbol" aria-roledescription="circle" transform="translate(50,122.2)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g></g></svg>

---

    Code
      cat(vw_to_svg(spec_wx, base_url = tempdir))
    Output
      <?xml version="1.0" encoding="utf-8"?>
      <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" class="marks" width="256" height="245" viewBox="0 0 256 245"><rect width="256" height="245" fill="white"/><g fill="none" stroke-miterlimit="10" transform="translate(51,8)"><g class="mark-group role-frame root" role="graphics-object" aria-roledescription="group mark container"><g transform="translate(0,0)"><path class="background" aria-hidden="true" d="M0.5,0.5h200v200h-200Z" stroke="#ddd"/><g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(44,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(89,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(133,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(178,-200)" x2="0" y2="200" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" aria-hidden="true"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-grid" pointer-events="none"><line transform="translate(0,200)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,155)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,109)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,64)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/><line transform="translate(0,18)" x2="200" y2="0" stroke="#ddd" stroke-width="1" opacity="1"/></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="X-axis titled 'temp_max' for a linear scale with values from 0 to 5"><g transform="translate(0.5,200.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(44,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(89,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(133,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(178,0)" x2="0" y2="5" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="start" transform="translate(0,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0</text><text text-anchor="middle" transform="translate(44.44444444444444,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">1</text><text text-anchor="middle" transform="translate(88.88888888888889,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">2</text><text text-anchor="middle" transform="translate(133.33333333333331,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">3</text><text text-anchor="middle" transform="translate(177.77777777777777,15)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">4</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,0)" x2="200" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(100,30)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">temp_max</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-group role-axis" role="graphics-symbol" aria-roledescription="axis" aria-label="Y-axis titled 'temp_min' for a linear scale with values from 0.0 to 2.2"><g transform="translate(0.5,0.5)"><path class="background" aria-hidden="true" d="M0,0h0v0h0Z" pointer-events="none"/><g><g class="mark-rule role-axis-tick" pointer-events="none"><line transform="translate(0,200)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,155)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,109)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,64)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/><line transform="translate(0,18)" x2="-5" y2="0" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-label" pointer-events="none"><text text-anchor="end" transform="translate(-7,203)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0.0</text><text text-anchor="end" transform="translate(-7,157.54545454545453)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">0.5</text><text text-anchor="end" transform="translate(-7,112.09090909090908)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">1.0</text><text text-anchor="end" transform="translate(-7,66.63636363636365)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">1.5</text><text text-anchor="end" transform="translate(-7,21.181818181818187)" font-family="sans-serif" font-size="10px" fill="#000" opacity="1">2.0</text></g><g class="mark-rule role-axis-domain" pointer-events="none"><line transform="translate(0,200)" x2="0" y2="-200" stroke="#888" stroke-width="1" opacity="1"/></g><g class="mark-text role-axis-title" pointer-events="none"><text text-anchor="middle" transform="translate(-35,100) rotate(-90) translate(0,-2)" font-family="sans-serif" font-size="11px" font-weight="bold" fill="#000" opacity="1">temp_min</text></g></g><path class="foreground" aria-hidden="true" d="" pointer-events="none" display="none"/></g></g><g class="mark-symbol role-mark marks" role="graphics-object" aria-roledescription="symbol mark container"><path aria-label="temp_max: 4.4; temp_min: 2.2" role="graphics-symbol" aria-roledescription="circle" transform="translate(195.55555555555557,0)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="temp_max: 4.4; temp_min: 0.6" role="graphics-symbol" aria-roledescription="circle" transform="translate(195.55555555555557,145.45454545454547)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="temp_max: 4.4; temp_min: 0.6" role="graphics-symbol" aria-roledescription="circle" transform="translate(195.55555555555557,145.45454545454547)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="temp_max: 3.9; temp_min: 0.6" role="graphics-symbol" aria-roledescription="circle" transform="translate(173.33333333333334,145.45454545454547)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/><path aria-label="temp_max: 4.4; temp_min: 1.7" role="graphics-symbol" aria-roledescription="circle" transform="translate(195.55555555555557,45.45454545454548)" d="M2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,-2.7386127875258306,0A2.7386127875258306,2.7386127875258306,0,1,1,2.7386127875258306,0" fill="#4c78a8" stroke-width="2" opacity="0.7"/></g></g><path class="foreground" aria-hidden="true" d="" display="none"/></g></g></g></svg>

