% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/js-handler.R
\name{vw_handler_add_effect}
\alias{vw_handler_add_effect}
\title{Add a side-effect to a JavaScript handler}
\usage{
vw_handler_add_effect(vw_handler, body_effect, ...)
}
\arguments{
\item{vw_handler}{\code{vw_handler} created using \code{\link[=vw_handler_signal]{vw_handler_signal()}} or
\code{\link[=vw_handler_event]{vw_handler_event()}}}

\item{body_effect}{\code{character}, the name of a defined handler-body,
or the text of the body of a handler-function}

\item{...}{additional \emph{named} parameters to be interpolated into the
text of the handler_body}
}
\value{
modified copy of \code{vw_handler}
}
\description{
With a JavaScript handler, once you have calculated a value
based on the handler's arguments (e.g. \code{name}, \code{value}) you will
likely want to produce a side-effect based on that calculated value.
This function helps you do that.
}
\details{
The calculation of a value is meant to be separate from the
production of a side-effect. This way, the code for a side-effect
can be used for any type of handler.

You are supplying the \code{body_effect} to an effect-handler. This
takes a single argument, \code{x}, representing the
calculated value. Doing this allows us to chain side-effects together;
be careful not to modify \code{x} in any of the code you provide.

To see what side-effects are available in this package's handler-library,
call \code{vw_handler_add_effect()} without any arguments. You may notice that
some of the effects, like \code{"element_text"}, require additional parameters,
in this case, \code{selector}.

Those parameters with a default value of \code{NULL} require you to supply
a value; those with sensible defaults are optional.

To provide the parameters, call
\code{vw_handler_add_effect()} with \emph{named} arguments corresponding to the
names of the parameters. See the examples for details.
}
\examples{
  # list all the available effect-handlers
  vw_handler_add_effect()

  # build a signal handler that prints some text,
  # then the value, to the console
  vw_handler_signal("value") \%>\%
    vw_handler_add_effect("console", label = "signal value:")

}
\seealso{
\code{\link[=vw_handler_signal]{vw_handler_signal()}}
}
