% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testthat-ui.R
\name{expect_doppelganger}
\alias{expect_doppelganger}
\title{Does a figure look like its expected output?}
\usage{
expect_doppelganger(title, fig, path = NULL, ..., user_fonts = NULL)
}
\arguments{
\item{title}{The figure title is used for creating the figure file
names (all non-alphanumeric characters are converted to
\code{-}). Also, ggplot2 figures are appended with
\code{ggtitle(title)}.}

\item{fig}{A figure to test.}

\item{path}{The path where the test case should be stored, relative
to the \code{tests/figs/} folder. If \code{NULL} (the default),
the current testthat context is used to create a
subfolder. Supply an empty string \code{""} if you want the
figures to be stored in the root folder.}

\item{...}{Additional arguments passed to
\code{\link[testthat]{compare}()} to control specifics of
comparison.}

\item{user_fonts}{Passed to \code{\link[svglite]{svglite}()} to
make sure SVG are reproducible. Defaults to Liberation fonts for
standard families and Symbola font for symbols.}
}
\description{
If the test has never been validated yet, the test is skipped. If
the test has previously been validated but \code{fig} does not look
like its expected output, an error is issued. Use
\code{\link{validate_cases}()} or \code{\link{manage_cases}()} to
(re)validate the test.
}
\details{
\code{fig} can be a ggplot object, a recordedplot, a function to be
called, or more generally any object with a \code{print} method. If
a ggplot object, a dependency for ggplot2 is automatically added
(see \code{\link{add_dependency}()}).
}
\examples{
disp_hist_base <- function() hist(mtcars$disp)
expect_doppelganger("disp-histogram-base", disp_hist_base)

if (requireNamespace("ggplot2", quietly = TRUE)) {
  library("ggplot2")
  disp_hist_ggplot <- ggplot(mtcars, aes(disp)) + geom_histogram()
  expect_doppelganger("disp-histogram-ggplot", disp_hist_ggplot)
}
}

