% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUI_collection.R
\name{GUI_collection}
\alias{GUI_collection}
\title{Launches the web-based GUI for visualizing time series}
\usage{
GUI_collection(collection)
}
\arguments{
\item{collection}{a list with the collection of time series. Each component
of the list must have been built with the \code{\link[=ts_info]{ts_info()}} function.}
}
\value{
Nothing
}
\description{
Launches the web-based GUI for visualizing a collection of time series in a
web browser.
}
\details{
The \strong{vctsfr} package provides a Shiny-based GUI to visualize collections of
time series and their forecasts. The main features of the GUI are:
\itemize{
\item It allows you to easily navigate through the different series.
\item You can select which forecasting methods are displayed.
\item In the case you display a single forecasting method with associated
prediction intervals, you can select the prediction interval to display.
\item Forecasting accuracy measures are displayed.
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a collection of two time series and visualize them
c <- list(ts_info(USAccDeaths), ts_info(ldeaths))
GUI_collection(c)
\dontshow{\}) # examplesIf}
}
