% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names.R
\name{vec_names}
\alias{vec_names}
\alias{vec_names2}
\alias{vec_set_names}
\title{Get or set the names of a vector}
\usage{
vec_names2(
  x,
  ...,
  repair = c("minimal", "unique", "universal", "check_unique"),
  quiet = FALSE
)

vec_names(x)

vec_set_names(x, names)
}
\arguments{
\item{x}{A vector with names}

\item{...}{These dots are for future extensions and must be empty.}

\item{repair}{Either a string or a function. If a string, it must
be one of \code{"check_unique"}, \code{"minimal"}, \code{"unique"}, or \code{"universal"}.
If a function, it is invoked with a vector of minimal names and must
return minimal names, otherwise an error is thrown.
\itemize{
\item Minimal names are never \code{NULL} or \code{NA}. When an element doesn't
have a name, its minimal name is an empty string.
\item Unique names are unique. A suffix is appended to duplicate
names to make them unique.
\item Universal names are unique and syntactic, meaning that you can
safely use the names as variables without causing a syntax
error.
}

The \code{"check_unique"} option doesn't perform any name repair.
Instead, an error is raised if the names don't suit the
\code{"unique"} criteria.}

\item{quiet}{By default, the user is informed of any renaming
caused by repairing the names. This only concerns unique and
universal repairing. Set \code{quiet} to \code{TRUE} to silence the
messages.

Users can silence the name repair messages by setting the
\code{"rlib_name_repair_verbosity"} global option to \code{"quiet"}.}

\item{names}{A character vector, or \code{NULL}.}
}
\value{
\code{vec_names2()} returns the names of \code{x}, repaired.
\code{vec_names()} returns the names of \code{x} or \code{NULL} if unnamed.
\code{vec_set_names()} returns \code{x} with names updated.
}
\description{
These functions work like \code{\link[rlang:names2]{rlang::names2()}}, \code{\link[=names]{names()}} and \code{\link[=names<-]{names<-()}},
except that they return or modify the the rowwise names of the vector. These are:
\itemize{
\item The usual \code{names()} for atomic vectors and lists
\item The row names for data frames and matrices
\item The names of the first dimension for arrays
Rowwise names are size consistent: the length of the names always equals
\code{\link[=vec_size]{vec_size()}}.
}

\code{vec_names2()} returns the repaired names from a vector, even if it is unnamed.
See \code{\link[=vec_as_names]{vec_as_names()}} for details on name repair.

\code{vec_names()} is a bare-bones version that returns \code{NULL} if the vector is
unnamed.

\code{vec_set_names()} sets the names or removes them.
}
\examples{
vec_names2(1:3)
vec_names2(1:3, repair = "unique")
vec_names2(c(a = 1, b = 2))

# `vec_names()` consistently returns the rowwise names of data frames and arrays:
vec_names(data.frame(a = 1, b = 2))
names(data.frame(a = 1, b = 2))
vec_names(mtcars)
names(mtcars)
vec_names(Titanic)
names(Titanic)

vec_set_names(1:3, letters[1:3])
vec_set_names(data.frame(a = 1:3), letters[1:3])
}
