% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_handler-crul.R
\docType{data}
\name{RequestHandlerCrul}
\alias{RequestHandlerCrul}
\title{RequestHandlerCrul - methods for crul package}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
RequestHandlerCrul
}
\description{
RequestHandlerCrul - methods for crul package
}
\details{
\strong{Public Methods}
\describe{
\item{\code{handle(request)}}{
Top level function to interact with. Handles the request
}
}

\strong{Private Methods}
\describe{
\item{\code{request_type(request)}}{
Get the request type
}
\item{\code{externally_stubbed()}}{
just returns FALSE
}
\item{\code{should_ignore()}}{
should we ignore the request, depends on request ignorer
infrastructure that's not working yet
}
\item{\code{has_response_stub()}}{
Check if there is a matching response stub in the
http interaction list
}
\item{\code{get_stubbed_response()}}{
Check for a response and get it
}
\item{\code{request_summary(request)}}{
get a request summary
}
\item{\code{on_externally_stubbed_request(request)}}{
on externally stubbed request do nothing
}
\item{\code{on_ignored_request(request)}}{
on ignored request, do something
}
\item{\code{on_recordable_request(request)}}{
on recordable request, record the request
}
\item{\code{on_unhandled_request(request)}}{
on unhandled request, run UnhandledHTTPRequestError
}
}
}
\examples{
\dontrun{
vcr_configure(
 dir = tempdir(),
 record = "once"
)

data(crul_request)
crul_request$url$handle <- curl::new_handle()
crul_request
x <- RequestHandlerCrul$new(crul_request)
# x$handle()

library(crul)
data(crul_request_post_json)
crul_request_post_json$request$url$handle <- curl::new_handle()
crul_request_post_json
crul_request_post_json$request
x <- RequestHandlerCrul$new(crul_request_post_json$request)
# x$handle()

# body matching
library(vcr)
library(crul)
vcr_configure(dir = tempdir(), log = TRUE)
cli <- HttpClient$new(url = "https://httpbin.org")

## testing, same uri and method, changed body in 2nd block
use_cassette(name = "apple7", {
  resp <- cli$post("post", body = list(foo = "bar"))
}, match_requests_on = c("method", "uri", "body"))
## should error, b/c record="once"
use_cassette(name = "apple7", {
  resp <- cli$post("post", body = list(foo = "bar"))
  resp2 <- cli$post("post", body = list(hello = "world"))
}, match_requests_on = c("method", "uri", "body"))
cas <- insert_cassette(name = "apple7", 
  match_requests_on = c("method", "uri", "body"))
resp2 <- cli$post("post", body = list(hello = "world"))
eject_cassette("apple7")

## testing, same body, changed method in 2nd block
use_cassette(name = "apple8", {
  x <- cli$post("post", body = list(hello = "world"))
}, match_requests_on = c("method", "body"))
use_cassette(name = "apple8", {
  x <- cli$get("post", body = list(hello = "world"))
}, match_requests_on = c("method", "body"))

## testing, same body, changed uri in 2nd block
use_cassette(name = "apple9", {
  x <- cli$post("post", body = list(hello = "world"))
  w <- cli$post("get", body = list(hello = "world"))
}, match_requests_on = c("method", "body"))
use_cassette(name = "apple9", {
  NOTHING HERE
}, match_requests_on = c("method", "body"))
unlink(file.path(vcr_configuration()$dir, "apple9.yml"))

jsonlite::fromJSON(resp$parse())
}
}
\keyword{datasets}
