% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.semipart}
\alias{meta.ave.semipart}
\title{Confidence interval for an average semipartial correlation}
\usage{
meta.ave.semipart(alpha, n, cor, r2, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{cor}{vector of estimated semipartial correlations}

\item{r2}{vector of squared multiple correlations for full model}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average semipartial correlation from two or more studies.
}
\examples{
n <- c(128, 97, 210, 217)
cor <- c(.35, .41, .44, .39)
r2 <- c(.29, .33, .36, .39)
meta.ave.semipart(.05, n, cor, r2, bystudy = TRUE)

# Should return:
#         Estimate         SE        LL        UL
# Average   0.3975 0.03221240 0.3325507 0.4586965
# Study 1   0.3500 0.07175200 0.2023485 0.4820930
# Study 2   0.4100 0.07886080 0.2447442 0.5521076
# Study 3   0.4400 0.05146694 0.3338366 0.5351410
# Study 4   0.3900 0.05085271 0.2860431 0.4848830


}
