% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.path}
\alias{meta.ave.path}
\title{Confidence interval for an average slope coefficient in a general
linear model or a path model.}
\usage{
meta.ave.path(alpha, n, slope, se, s, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{slope}{vector of slope estimates}

\item{se}{vector of slope standard errors}

\item{s}{number of predictors of the response variable}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - the estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average slope coefficient in a general linear model (ANOVA, ANCOVA,
multiple regression) or a path model from two or more studies.
}
\examples{
 
n <- c(75, 85, 250, 160)
slope <- c(1.57, 1.38, 1.08, 1.25)
se <- c(.658, .724, .307, .493)
meta.ave.path(.05, n, slope, se, 2, bystudy = TRUE)

#  Should return:
#         Estimate         SE          LL       UL       df
#  Average     1.32 0.2844334  0.75994528 1.880055 263.1837
#  Study 1     1.57 0.6580000  0.25830097 2.881699  72.0000
#  Study 2     1.38 0.7240000 -0.06026664 2.820267  82.0000
#  Study 3     1.08 0.3070000  0.47532827 1.684672 247.0000
#  Study 4     1.25 0.4930000  0.27623174 2.223768 157.0000


}
