% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.agree}
\alias{meta.lm.agree}
\title{Meta-regression analysis for G agreement indices}
\usage{
meta.lm.agree(alpha, f11, f12, f21, f22, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f11}{vector of frequencies in cell 1,1}

\item{f12}{vector of frequencies in cell 1,2}

\item{f21}{vector of frequencies in cell 2,1}

\item{f22}{vector of frequencies in cell 2,2}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a G-index of
agreement. The estimates are OLS estimates with standard errors
that accomodate residual heteroscedasticity.
}
\examples{
f11 <- c(40, 20, 25, 30)
f12 <- c(3, 2, 2, 1)
f21 <- c(7, 6, 8, 6)
f22 <- c(26, 25, 13, 25)
x1 <- c(1, 1, 4, 6)
x2 <- c(1, 1, 0, 0)
X <- matrix(cbind(x1, x2), 4, 2)
meta.lm.agree(.05, f11, f12, f21, f22, X)

# Should return:
#     Estimate         SE         z     p          LL        UL
# b0 0.1904762 0.38772858 0.4912617 0.623 -0.56945786 0.9504102
# b1 0.0952381 0.07141957 1.3335013 0.182 -0.04474169 0.2352179
# b2 0.4205147 0.32383556 1.2985438 0.194 -0.21419136 1.0552207


}
