% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.stdmean.ps}
\alias{replicate.stdmean.ps}
\title{Compares paired-samples standardized mean differences in original and
follow-up studies}
\usage{
replicate.stdmean.ps(
  alpha,
  m11,
  m12,
  sd11,
  sd12,
  cor1,
  n1,
  m21,
  m22,
  sd21,
  sd22,
  cor2,
  n2
)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m11}{sample mean for group 1 in original study}

\item{m12}{sample mean for group 2 in original study}

\item{sd11}{sample SD for group 1 in original study}

\item{sd12}{sample SD for group 2 in original study}

\item{cor1}{sample correlation of paired observations in orginal study}

\item{n1}{sample size in original study}

\item{m21}{sample mean for group 1 in follow-up study}

\item{m22}{sample mean for group 2 in follow-up study}

\item{sd21}{sample SD for group 1 in follow-up study}

\item{sd22}{sample SD for group 2 in follow-up study}

\item{cor2}{sample correlation of paired observations in follow-up study}

\item{n2}{sample size in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the Original study
\item Row 2 summarizes the Follow-up study
\item Row 3 estimates the difference between studies
\item Row 4 estimates the average effect size between the two studies
}

The columns are:
\itemize{
\item Estimate - effect size estimate
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function computes confidence intervals for a paired-samples standardized
mean difference from an original study and a follow-up study. Confidence intervals
for the difference and average effect size also are computed. The same results can
be obtained using the \link[vcmeta]{meta.lc.stdmean.ps} function with appropriate
contrast coefficients. The confidence level for the difference is 1 – 2alpha.
}
\examples{
replicate.stdmean.ps(
  alpha = .05, 
  m11 = 86.22, m12 = 70.93, sd11 = 14.89, sd12 = 12.32, cor1 = .765, n1 = 20, 
  m21 = 84.81, m22 = 77.24, sd21 = 15.68, sd22 = 16.95, cor2 = .702, n2 = 75
)

# Should return:
#                         Estimate         SE        LL        UL
#  Orginal:              1.0890300 0.22915553 0.6697353 1.5680085
#  Follow-up:            0.4604958 0.09590506 0.2756687 0.6516096
#  Original - Follow-up: 0.6552328 0.24841505 0.2466264 1.0638392
#  Average:              0.7747629 0.12420752 0.5313206 1.0182052


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
