% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vcfreader}
\alias{vcfreader}
\title{API for manipulating the VCF/BCF.}
\value{
A C++ class with the following fields/methods for manipulating the VCF/BCF
}
\description{
Type the name of the class to see the details and methods
}
\section{Fields}{

\describe{
\item{\code{new}}{Constructor given a vcf file \itemize{
\item Parameter: vcffile - The path of a vcf file
}}

\item{\code{new}}{Constructor given a vcf file and the region \itemize{
\item Parameter: vcffile - The path of a vcf file
\item Parameter: region - The region to be constrained
}}

\item{\code{new}}{Constructor given a vcf file, the region and the samples \itemize{
\item Parameter: vcffile - The path of a vcf file
\item Parameter: region - The region to be constrained
\item Parameter: samples - The samples to be constrained. Comma separated list of samples to include (or exclude with "^" prefix).
}}

\item{\code{variant}}{Try to get next variant record. return FALSE if there are no more variants or hit the end of file, otherwise TRUE.}

\item{\code{chr}}{Return the CHROM field of current variant}

\item{\code{pos}}{Return the POS field of current variant}

\item{\code{id}}{Return the CHROM field of current variant}

\item{\code{ref}}{Return the REF field of current variant}

\item{\code{alt}}{Return the ALT field of current variant}

\item{\code{qual}}{Return the QUAL field of current variant}

\item{\code{filter}}{Return the FILTER field of current variant}

\item{\code{info}}{Return the INFO field of current variant}

\item{\code{infoInt}}{Return the tag value of integer type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}}

\item{\code{infoFloat}}{Return the tag value of float type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}}

\item{\code{infoStr}}{Return the tag value of string type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}}

\item{\code{infoIntVec}}{Return the tag value in a vector of integer type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}}

\item{\code{infoFloatVec}}{Return the tag value in a vector of float type in INFO field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in INFO}}

\item{\code{genotypes}}{Return the genotype values in a vector of integers  \itemize{ \item Parameter: collapse - Boolean value indicates wheather to collapse the size of genotypes, eg, return diploid genotypes.}}

\item{\code{formatInt}}{Return the tag value of integer type for each sample in FORAMT field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in FORAMT}}

\item{\code{formatFloat}}{Return the tag value of float type for each sample in FORAMT field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in FORAMT}}

\item{\code{formatStr}}{Return the tag value of string type for each sample in FORAMT field of current variant \itemize{ \item Parameter: tag - The tag name to retrieve in FORAMT}}

\item{\code{isSNP}}{Test if current variant is exculsively a SNP or not}

\item{\code{isIndel}}{Test if current variant is exculsively a INDEL or not}

\item{\code{isSV}}{Test if current variant is exculsively a SV or not}

\item{\code{isMultiAllelics}}{Test if current variant is exculsively a Multi Allelics or not}

\item{\code{isMultiAllelicSNP}}{Test if current variant is exculsively a Multi Biallelics (SNPs) or not}

\item{\code{hasSNP}}{Test if current variant has a SNP or not}

\item{\code{hasINDEL}}{Test if current variant has a INDEL or not}

\item{\code{hasINS}}{Test if current variant has a INS or not}

\item{\code{hasDEL}}{Test if current variant has a DEL or not}

\item{\code{hasMNP}}{Test if current variant has a MNP or not}

\item{\code{hasBND}}{Test if current variant has a BND or not}

\item{\code{hasOTHER}}{Test if current variant has a OTHER or not}

\item{\code{hasOVERLAP}}{Test if current variant has a OVERLAP or not}

\item{\code{nsamples}}{Return the number of samples}

\item{\code{samples}}{Return a vector of samples id}

\item{\code{header}}{Return the raw string of the vcf header}

\item{\code{string}}{Return the raw string of current variant including newline}

\item{\code{line}}{Return the raw string of current variant without newline}

\item{\code{output}}{Init an output object for streaming out the variants to another vcf}

\item{\code{write}}{Streaming out current variant the output vcf}

\item{\code{close}}{Close the connection to the output vcf}

\item{\code{setCHR}}{Modify the CHR of current variant \itemize{ \item Parameter: s - A string for CHR}}

\item{\code{setID}}{Modify the ID of current variant \itemize{ \item Parameter: s - A string for ID}}

\item{\code{setPOS}}{Modify the POS of current variant \itemize{ \item Parameter: pos - An integer for POS}}

\item{\code{setRefAlt}}{Modify the REF and ALT of current variant \itemize{ \item Parameter: s - A string reperated by comma}}

\item{\code{setInfoInt}}{Modify the given tag of INT type in the INFO of current variant
\itemize{
\item Parameter: tag - A string for the tag name
\item Parameter: v - An integer for the tag value}}

\item{\code{setInfoFloat}}{Modify the given tag of FLOAT type in the INFO of current variant
\itemize{
\item Parameter: tag - A string for the tag name
\item Parameter: v - A double for the tag value}}

\item{\code{setInfoStr}}{Modify the given tag of STRING type in the INFO of current variant
\itemize{
\item Parameter: tag - A string for the tag name
\item Parameter: s - A string for the tag value}}

\item{\code{setPhasing}}{Modify the phasing status of each sample
\itemize{\item Parameter: v - An integer vector with size of the number of samples. only 1s and 0s are valid.}}

\item{\code{setGenotypes}}{Modify the genotypes of current variant
\itemize{\item Parameter: v - An integer vector for genotypes. Use NA or -9 for missing value.}}

\item{\code{setFormatInt}}{Modify the given tag of INT type in the FORMAT of current variant
\itemize{
\item Parameter: tag - A string for the tag name
\item Parameter: v - An integer for the tag value}}

\item{\code{setFormatFloat}}{Modify the given tag of FLOAT type in the FORMAT of current variant
\itemize{
\item Parameter: tag - A string for the tag name
\item Parameter: v - A double for the tag value}}

\item{\code{setFormatStr}}{Modify the given tag of STRING type in the FORMAT of current variant
\itemize{
\item Parameter: tag - A string for the tag name
\item Parameter: s - A string for the tag value}}

\item{\code{rmInfoTag}}{Remove the given tag from the INFO of current variant
\itemize{\item Parameter: s - A string for the tag name}}

\item{\code{rmFormatTag}}{Remove the given tag from the FORMAT of current variant
\itemize{\item Parameter: s - A string for the tag name}}

\item{\code{setVariant}}{Modify current variant by adding a vcf line
\itemize{\item Parameter: s - A string for one line in the VCF}}

\item{\code{addINFO}}{Add a INFO in the header of the vcf
\itemize{
\item Parameter: id - A string for the tag name
\item Parameter: number - A string for the number
\item Parameter: type - A string for the type
\item Parameter: desc - A string for description of what it means}}

\item{\code{addFORMAT}}{Add a FORMAT in the header of the vcf
\itemize{
\item Parameter: id - A string for the tag name
\item Parameter: number - A string for the number
\item Parameter: type - A string for the type
\item Parameter: desc - A string for description of what it means}}
}}

\examples{
vcffile <- system.file("extdata", "raw.gt.vcf.gz", package="vcfppR")
br <- vcfreader$new(vcffile)
res <- rep(0L, br$nsamples())
while(br$variant()) {
  if(br$isSNP()) {
  gt <- br$genotypes(TRUE) == 1
  gt[is.na(gt)] <- FALSE
  res <- res + gt
  }
}
}
