"roots" <-
function(x, modulus = TRUE){
  if(!is(x, "varest")){
    stop("\nPlease provide an object of class 'varest', generated by 'VAR()'.\n")
  }
  K <- x$K
  p <- x$p
  A <- unlist(Acoef(x))
  companion <- matrix(0, nrow = K * p, ncol = K * p)
  companion[1:K, 1:(K * p)] <- A
  if(p > 1){
    j <- 0
    for( i in (K + 1) : (K*p)){
      j <- j + 1
      companion[i, j] <- 1
    }
  }
  roots <- eigen(companion)$values
  if(modulus) roots <- Mod(roots)
  return(roots)
}
