% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour_input_geometry.R
\name{vapour_layer_info}
\alias{vapour_layer_info}
\title{Read GDAL layer info}
\usage{
vapour_layer_info(dsource, layer = 0L, sql = "", ...)
}
\arguments{
\item{dsource}{data source name (path to file, connection string, URL)}

\item{layer}{integer of layer to work with, defaults to the first (0) or the name of the layer}

\item{sql}{if not empty this is executed against the data source (layer will be ignored)}

\item{...}{unused, reserved for future use}
}
\value{
list with a list of character vectors of projection metadata, see details
}
\description{
Read GDAL layer information for a vector data source.
}
\details{
Currently we only return \verb{$projection} which is a list of various formats of the projection metadata.
Use \verb{$projection$Wkt} as most authoritative, but we don't enter into the discussion or limit what
might be done with this (that's up to you). Currently we see
\code{c("Proj4", "MICoordSys", "PrettyWkt", "Wkt", "EPSG", "XML")} as names of this \verb{$projection} element.

Future versions might also include the attribute field types, the feature count, the file list, what else?
}
\examples{
file <- "list_locality_postcode_meander_valley.tab"
## A MapInfo TAB file with polygons
mvfile <- system.file(file.path("extdata/tab", file), package="vapour")
names(vapour_layer_info(mvfile)$projection)
}
