% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openxlsxCommands.R
\name{oxAlignOverlapSheet}
\alias{oxAlignOverlapSheet}
\title{Align Overlap Data Sheet}
\usage{
oxAlignOverlapSheet(wb.name, sheet.name = "AlignOverlap", df)
}
\arguments{
\item{wb.name}{Name of the workbook for the results; \emph{e.g.}, results.wb}

\item{sheet.name}{Name of the worksheet being formatted; default:
\code{"AlignOverlap"}}

\item{df}{data.frame containing the summary of \code{\link[=AlignOverlap]{AlignOverlap()}}; \emph{e.g.},
\code{df.results}}
}
\value{
The workbook containing the indicated and newly formatted worksheet.
}
\description{
Constructs the \link{openxlsx} worksheet for the
\code{\link[=AlignOverlap]{AlignOverlap()}} results.
}
\details{
\strong{This function is to \emph{ONLY} be used with the results of
\code{\link[=AlignOverlap]{AlignOverlap()}}}. Specific aspects of how the
returned \code{data.frame} will be formatted are \strong{hard-coded} into this
function.

Notable formatting:
\itemize{
\item Top row frozen
\item Column widths are set based on column content
\item Structures passing the \code{\link[=AlignOverlap]{AlignOverlap()}} evaluation are hightlighted
lime green
\item Structures failing the \code{\link[=AlignOverlap]{AlignOverlap()}} evaluation are hightlighted
pink
}

This \link{openxlsx} function is \emph{\strong{NOT}} exported.
}
\seealso{
Other "openxlsx functions": \code{\link{openxlsxCellStyles}},
  \code{\link{oxClusterStatsSheet}},
  \code{\link{oxClusterSummarySheet}},
  \code{\link{oxInitWaterDataSheet}},
  \code{\link{oxPDBcleanedSummarySheet}},
  \code{\link{oxPlainDataSheet}},
  \code{\link{oxRCSBinfoSheet}},
  \code{\link{oxWaterOccurrenceSheet}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"openxlsx functions"}
