% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_comparison.R
\name{.calculate_quantiles}
\alias{.calculate_quantiles}
\title{.calculate_quantiles}
\usage{
.calculate_quantiles(
  data_array,
  data_margin = 2,
  quantile_levels = c(min = 0, `2.5\%` = 0.025, `25\%` = 0.25, median = 0.5, `75\%` =
    0.75, `97.5\%` = 0.975, max = 1)
)
}
\arguments{
\item{data_array}{A numeric array where calculations will be performed on each column. The array can be 2D or 3D.}

\item{data_margin}{An integer that indicates the margin on which to apply the function. Default is 2.}

\item{quantile_levels}{A named numeric vector of probabilities for which quantiles are required.}
}
\value{
A data frame with columns for each calculated statistic, including mean, standard deviation, and user-specified quantiles.
}
\description{
This function calculates the mean, standard deviation, and specified quantiles for each column in a provided data array.
}
\keyword{internal}
