% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_merge.r
\name{bed_merge}
\alias{bed_merge}
\title{Merge overlapping intervals.}
\usage{
bed_merge(x, max_dist = 0, ...)
}
\arguments{
\item{x}{\link{ivl_df}}

\item{max_dist}{maximum distance between intervals to merge}

\item{...}{name-value pairs that specify operations on merged intervals}
}
\value{
\link{ivl_df}
}
\description{
Operations can be performed on merged intervals by specifying name-value
pairs. Default \code{max_dist} of \code{0} means book-ended intervals are
merged.
}
\details{
input tbls are grouped by \code{chrom} by default, and additional
groups can be added using \code{\link[dplyr:group_by]{dplyr::group_by()}}. For example,
grouping by \code{strand} will constrain analyses to the same strand. To
compare opposing strands across two tbls, strands on the \code{y} tbl can
first be inverted using \code{\link[=flip_strands]{flip_strands()}}.
}
\examples{
x <- tibble::tribble(
  ~chrom, ~start, ~end,
  'chr1',  1,      50,
  'chr1',  10,     75,
  'chr1',  100,    120
)

bed_glyph(bed_merge(x))

x <- tibble::tribble(
 ~chrom, ~start, ~end, ~value, ~strand,
 "chr1", 1,      50,   1,      '+',
 "chr1", 100,    200,  2,      '+',
 "chr1", 150,    250,  3,      '-',
 "chr2", 1,      25,   4,      '+',
 "chr2", 200,    400,  5,      '-',
 "chr2", 400,    500,  6,      '+',
 "chr2", 450,    550,  7,      '+'
)

bed_merge(x)

bed_merge(x, max_dist = 100)

# merge intervals on same strand
bed_merge(dplyr::group_by(x, strand))

bed_merge(x, .value = sum(value))

}
\seealso{
\url{http://bedtools.readthedocs.org/en/latest/content/tools/merge.html}

Other single set operations: 
\code{\link{bed_cluster}()},
\code{\link{bed_complement}()},
\code{\link{bed_flank}()},
\code{\link{bed_partition}()},
\code{\link{bed_shift}()},
\code{\link{bed_slop}()}
}
\concept{single set operations}
