% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_shuffle.r
\name{bed_shuffle}
\alias{bed_shuffle}
\title{Shuffle input intervals.}
\usage{
bed_shuffle(x, genome, incl = NULL, excl = NULL, max_tries = 1000,
  within = FALSE, seed = 0)
}
\arguments{
\item{x}{tbl of intervals}

\item{genome}{chrom sizes}

\item{incl}{tbl of included intervals}

\item{excl}{tbl of excluded intervals}

\item{max_tries}{maximum tries to identify a bounded interval}

\item{within}{shuffle within chromosomes}

\item{seed}{seed for reproducible intervals}
}
\value{
\code{data_frame}
}
\description{
Shuffle input intervals.
}
\examples{
genome <- tibble::tribble(
 ~chrom, ~size,
 "chr1", 1e6,
 "chr2", 2e6,
 "chr3", 4e6
)

x <- bed_random(genome)
bed_shuffle(x, genome)

}
\seealso{
\url{http://bedtools.readthedocs.io/en/latest/content/tools/shuffle.html}

Other single-set-ops: \code{\link{bed_cluster}},
  \code{\link{bed_complement}}, \code{\link{bed_flank}},
  \code{\link{bed_merge}}, \code{\link{bed_random}},
  \code{\link{bed_shift}}, \code{\link{bed_slop}}
}

