% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeriesData.R
\name{getSeriesData}
\alias{getSeriesData}
\title{Retrieves series' observations}
\usage{
getSeriesData(series, ...)
}
\arguments{
\item{series}{character string of \code{length} \eqn{>= 1}. It accepts both series' link and
their name only (see \strong{Details}).}

\item{...}{additional API's query arguments. See \strong{Details}}
}
\value{
An object of class list of one or more \code{data.frame}s with \eqn{n x 5} dimensions each. The
colums are respectively: \code{series_name}, \code{series_label}, \code{series_desc},
\code{d} (observation date) and \code{v} (series values).
}
\description{
\code{valetr} workhorse function. \code{getSeriesData()} retrieves observations from one or
more series. This list may have one or more components. Each component is a series. This
function accepts query arguments as specified on the
\href{https://www.bankofcanada.ca/valet/docs#observations_by_series}{API's manual}.
}
\details{
\strong{\code{series}}

    The argument \code{series} accepts a character vector in which each element is either
    a series link or a series name. \code{getSeriesData()} does not throw an error if some
    components do not have a valid name or link in the API. Instead, \code{getSeriesData()}
    issues a warning message with the series and API error message details. Additionally,
    the final output removes elements without a valid link. If all components in
    \code{series} do not have a valid address then the function throws an error.

\strong{\code{...}}

   The following arguments are accepted in \code{...}: \code{start_date}, \code{end_date},
   \code{recent}, \code{recent_weeks}, \code{recent_months}, \code{recent_years}. These are
   the API's options for time subsetting (see \href{https://www.bankofcanada.ca/valet/docs#observations_by_series}{API documentation}).
   Only \code{start_date} and \code{end_date} can be jointly used in \code{...}. Using any
   other combination of two or more arguments causes \code{getSeriesData()} to accept only
   one of them according to a pre-established hierarchy. This argument hierarchy causes the function
   to ignore the additional arguments. The hiearchy flows as follows:
   \itemize{
       \item{\code{start_date} and \code{end_date}}
       \item{\code{recent}}
       \item{\code{recent_weeks}}
       \item{\code{recent_months}}
       \item{\code{recent_years}}
   }

   The function converts numeric inputs to \code{recent}.

   The series observations may have a frequency that is not compatible to the query
   (i.e. recent_weeks query in a monthly series). Valet API converts the query time
   interval into the corresponding frequency of the series. If the time interval component
   is less than the most recent observation in the series, \code{getSeriesData()} returns
   a \code{data.frame} with a single row containing the series information. This behaviour
   allows \code{getSeriesData()} to return some series for which there is a valid interval.
   Also note that any invalid arguments passed to \code{...} is ignored during execution.
   For more details on the arguments' input format, see \strong{examples}, the package's
   vignette and \href{https://www.bankofcanada.ca/valet/docs#observations_by_series}{Valet's documentation}.
}
\examples{

\donttest{

### step 1: find the series link or name
# get series info
seriesInfo <- getSeriesInfo(patternGroupLabel="(?i)consumer price",
                            patternSeriesLabel="(?i)seasonally")

# use link from resulting object to get series obs
series <- getSeriesData(seriesInfo[["series_link"]])

#### query example ####
# ex1: start and end date
series <- getSeriesData(seriesInfo[["series_link"]],
                        start_date="2010-01-01", end_date="2012-01-01")

# ex2: the most recent 10 obs
series <- getSeriesData(seriesInfo[["series_link"]], recent=10L)

# ex3: most recent weeks
series <- getSeriesData(seriesInfo[["series_link"]], recent_weeks=20L)

# ex4: most recent months
series <- getSeriesData(seriesInfo[["series_link"]], recent_months=29L)

# ex4: most recent years
series <- getSeriesData(seriesInfo[["series_link"]], recent_years=20L)
}
}
