% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkers.R
\name{scalar-type-checkers}
\alias{scalar-type-checkers}
\title{Scalar type checkers}
\arguments{
\item{\dots}{Check items, i.e., formulae that are one-sided or have a string
as left-hand side (see \emph{Check Formulae of Local Scope} in the
documentation page \link{firmly}). These are the expressions to check.}
}
\value{
Check formula of local scope.
}
\description{
These functions make check formulae of local scope based on the
correspondingly named scalar type predicate from the
\href{https://cran.r-project.org/package=purrr}{\pkg{purrr}}
package. For example, \code{vld_scalar_atomic} creates check formulae (of
local scope) for the predicate function
\code{\link[purrr]{is_scalar_atomic}}. \cr\cr The functions
\code{vld_boolean}, \code{vld_number}, \code{vld_string},
\code{vld_singleton} are aliases for \code{vld_scalar_logical},
\code{vld_scalar_numeric}, \code{vld_scalar_character},
\code{vld_scalar_vector}, resp. (with appropriately modified error messages).
}
\details{
Each function \code{vld_*} is a function of class
  \code{"check_maker"}, generated by \code{\link{localize}}.
}
\examples{
\dontrun{

f <- function(x, y) "Pass"

# Impose a check on x: ensure it's boolean (i.e., a scalar logical vector)
f_firm <- firmly(f, vld_boolean(~x))
f_firm(TRUE, 0)           # [1] "Pass"
f_firm(c(TRUE, TRUE), 0)  # Error: "Not boolean: x"

# Use a custom error message
f_firm <- firmly(f, vld_boolean("x is not TRUE/FALSE/NA" ~ x))
f_firm(c(TRUE, TRUE), 0)  # Error: "x is not TRUE/FALSE/NA"

# To impose the same check on all arguments, apply globalize
f_firmer <- firmly(f, globalize(vld_boolean))
f_firmer(TRUE, FALSE)    # [1] "Pass"
f_firmer(TRUE, 0)        # Error: "Not boolean: `y`"
f_firmer(logical(0), 0)  # Errors: "Not boolean: `x`", "Not boolean: `y`"
}
}
\alias{vld_scalar_atomic}
\alias{vld_scalar_character}
\alias{vld_scalar_double}
\alias{vld_scalar_integer}
\alias{vld_scalar_list}
\alias{vld_scalar_logical}
\alias{vld_scalar_vector}
\alias{vld_boolean}
\alias{vld_string}
\alias{vld_singleton}
\usage{
vld_scalar_atomic(...)

vld_scalar_character(...)

vld_scalar_double(...)

vld_scalar_integer(...)

vld_scalar_list(...)

vld_scalar_logical(...)

vld_scalar_vector(...)

vld_boolean(...)

vld_string(...)

vld_singleton(...)
}
\seealso{
Corresponding predicates: Scalar type predicates (\href{https://cran.r-project.org/package=purrr}{\pkg{purrr}})

\code{\link{globalize}} recovers the underlying check formula of global scope.

The notions of \dQuote{scope} and \dQuote{check item} are explained in the \emph{Check Formulae} section of \link{firmly}.

\code{\link{vld_scalar_numeric}} does not check according to type, and is not based on \code{purrr::is_scalar_numeric} (deprecated since 0.2.2.9000); rather, it is based on the predicate \code{function(x) is.numeric(x) && length(x) == 1L}, which checks whether an object is \dQuote{numerical} in the sense of \code{\link[base]{mode}} instead of \code{\link[base]{typeof}}. In particular, factors are not regarded as \dQuote{numerical}.

Other checkers: \link{misc-checkers}, \link{bare-type-checkers}, \link{type-checkers}
}
