% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{trim}
\alias{trim}
\title{Trim data for plotting/reporting}
\usage{
trim(ests, dat, quantiles)
}
\arguments{
\item{ests}{An object of class \code{"vaccine_est"} returned by
\code{\link{est_ce}}.}

\item{dat}{The data object originally passed into \code{\link{est_ce}}.}

\item{quantiles}{A vector of length 2 representing the quantiles of the
marker distribution at which to trim the data; if, for example,
\code{quantiles=c(0.1,0.9)} is specified, values outside the 10% and 90%
(weighted) quantiles of the marker distribution will be trimmed.}
}
\value{
A modified copy of \code{ests} with the data trimmed.
}
\description{
Removes a subset of estimates returned by \code{\link{est_ce}}
}
\examples{
data(hvtn505)
dat <- load_data(time="HIVwk28preunblfu", event="HIVwk28preunbl", vacc="trt",
                 marker="IgG_V2", covariates=c("age","BMI","bhvrisk"),
                 weights="wt", ph2="casecontrol", data=hvtn505)
\donttest{
ests_cox <- est_ce(dat=dat, type="Cox", t_0=578)
ests_cox <- trim(ests_cox, dat=dat, quantiles=c(0.1,0.9))
plot_ce(ests_cox, density_type="kde", dat=dat)
}
}
