% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concat_conserved_kmer.R
\name{concat_conserved_kmer}
\alias{concat_conserved_kmer}
\title{k-mer sequences concatenation}
\usage{
concat_conserved_kmer(
  data,
  conservation_level = "HCS",
  kmer = 9,
  threshold_pct = NULL
)
}
\arguments{
\item{data}{DiMA JSON converted csv file data}

\item{conservation_level}{CCS (completely conserved) / HCS (highly conserved)}

\item{kmer}{size of the k-mer window}

\item{threshold_pct}{manually set threshold of index.incidence for HCS}
}
\value{
A list wit csv and fasta dataframes
}
\description{
This function concatenates completely (index incidence = 100%)/highly (90% <=
index incidence < 100%) conserved k-mer positions that overlapped at least one
k-mer position or are adjacent to each other and generate the CCS/HCS sequence
in either CSv or FASTA format
}
\examples{
csv<-concat_conserved_kmer(proteins_1host)$csv
csv_2hosts<-concat_conserved_kmer(protein_2hosts, conservation_level = "CCS")$csv
fasta <- concat_conserved_kmer(protein_2hosts, conservation_level = "HCS")$fasta
}
