% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlresult.R
\name{multilabel_prediction}
\alias{multilabel_prediction}
\title{Create a mlresult object}
\usage{
multilabel_prediction(
  bipartitions,
  probabilities,
  probability = getOption("utiml.use.probs", TRUE),
  empty.prediction = getOption("utiml.empty.prediction", FALSE)
)
}
\arguments{
\item{bipartitions}{The matrix of predictions (bipartition values),
only 0 and 1}

\item{probabilities}{The matrix of probability/confidence of a prediction,
between 0..1}

\item{probability}{A logical value. If \code{TRUE} the predicted values are
the score between 0 and 1, otherwise the values are bipartition 0 or 1.
(Default: \code{getOption("utiml.use.probs", TRUE)})}

\item{empty.prediction}{A logical value. If \code{TRUE} the predicted values
may contains empty values, otherwise at least one label will be positive for
each instance.}
}
\value{
An object of type mlresult
}
\description{
Create a mlresult object
}
\examples{
probs <- matrix(
 runif(90), ncol=3, dimnames = list(1:30, c("y1", "y2", "y3"))
)
preds <- matrix(
 as.numeric(probs > 0.5), ncol=3, dimnames = list(1:30, c("y1", "y2", "y3"))
)
multilabel_prediction(probs, preds)
}
