% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{fixed_threshold}
\alias{fixed_threshold}
\alias{fixed_threshold.default}
\alias{fixed_threshold.mlresult}
\title{Apply a fixed threshold in the results}
\usage{
fixed_threshold(prediction, threshold = 0.5, probability = FALSE)

\method{fixed_threshold}{default}(prediction, threshold = 0.5, probability = FALSE)

\method{fixed_threshold}{mlresult}(prediction, threshold = 0.5, probability = FALSE)
}
\arguments{
\item{prediction}{A matrix with scores/probabilities where the columns
are the labels and the rows are the instances.}

\item{threshold}{A single value between 0 and 1 or a list with threshold
values contained one value per label.}

\item{probability}{A logical value. If \code{TRUE} the predicted values are
the score between 0 and 1, otherwise the values are bipartition 0 or 1.
(Default: \code{FALSE})}
}
\value{
A mlresult object.
}
\description{
Transform a prediction matrix with scores/probabilities in a mlresult
applying a fixed threshold. A global fixed threshold can be used of all
labels or different fixed thresholds, one for each label.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Fixed Threshold for matrix or data.frame

\item \code{mlresult}: Fixed Threshold for mlresult
}}

\examples{
# Create a prediction matrix with scores
result <- matrix(
 data = rnorm(9, 0.5, 0.2),
 ncol = 3,
 dimnames = list(NULL, c('lbl1',  'lb2', 'lb3'))
)

# Use 0.5 as threshold
fixed_threshold(result)

# Use an threshold for each label
fixed_threshold(result, c(0.4, 0.6, 0.7))
}
\references{
Al-Otaibi, R., Flach, P., & Kull, M. (2014). Multi-label Classification: A
 Comparative Study on Threshold Selection Methods. In First International
 Workshop on Learning over Multiple Contexts (LMCE) at ECML-PKDD 2014.
}
\seealso{
Other threshold: 
\code{\link{lcard_threshold}()},
\code{\link{mcut_threshold}()},
\code{\link{pcut_threshold}()},
\code{\link{rcut_threshold}()},
\code{\link{scut_threshold}()},
\code{\link{subset_correction}()}
}
\concept{threshold}
