% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KDE.R
\name{KDE}
\alias{KDE}
\title{Kernel Density Estimator}
\usage{
KDE(
  data,
  weights = NULL,
  bandwidth = NULL,
  df = Inf,
  density.name = "kde",
  value.name = "Value",
  discrete = FALSE,
  discrete.warn = TRUE,
  to.environment = FALSE,
  envir = .GlobalEnv
)
}
\arguments{
\item{data}{Input data for the kernel density estimator (a numeric vector)}

\item{weights}{Weights for the kernel density estimator (a numeric vector with the same length as the data)}

\item{bandwidth}{Bandwidth for the KDE; if \code{NULL} it is estimated}

\item{df}{Degrees-of-freedom for the T-distribution}

\item{density.name}{Name of the KDE distribution; used for naming of the probability functions (a character string)}

\item{value.name}{Name of the values in the data; used for naming the plot of the KDE}

\item{discrete}{Logical; if \code{TRUE} the function produces a discrete KDE over the integers}

\item{discrete.warn}{Logical; if \code{TRUE} the function gives a warning if non-discrete data is used to produce a discrete KDE}

\item{to.environment}{Logical; if \code{TRUE} the probability functions are attached to the global environment}

\item{envir}{The environment where the probability functions are loaded (if \code{to.environment} is \code{TRUE})}
}
\value{
A \code{kde} object containing the probability functions for the kernel density estimator
}
\description{
\code{KDE} returns the probability function for the kernel density estimator
}
\details{
The kernel density estimator for a set of input data is obtained by taking a mixture distribution
consisting of a (possibly weighted) combination of kernels.  In this function we compute the KDE
using the kernel of the T-distribution; the function can also estimate a discretised version of the
KDE (taken over the integers) if required.  The degrees-of-freedom and the bandwidth for the KDE can
be specified in the inputs; if the bandwidth is not specified then it are estimated using the methods
set out in Sheather and Jones (1991) used in the \code{stats::density} function.  The output of the
function is a list of class \code{kde} that contains the probability functions for the KDE and
associated information.  The output object can be plotted to show the density function for the KDE.

Note: The function has an option \code{to.environment} to allow the user to load the probability
functions to the global environment or another specified environment.  If this is set to \code{TRUE}
then the probability functions are loaded to the specified environment in addition to appearing as
elements of the output; there is a message informing the user if existing objects in the global
environment were overwritten.  If the functions are not loaded to the environment then the user
can use the function \code{KDE.load} to load them later from the produced object.
}
\examples{
k <- KDE(rnorm(500))
print(k)
plot(k)
KDE.load(k, environment()); ls()
}
