% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softmax.R
\name{softmax}
\alias{softmax}
\alias{softmaxinv}
\title{Softmax and inverse-softmax functions}
\usage{
softmax(eta, lambda = 1, gradient = FALSE, hessian = FALSE)

softmaxinv(p, lambda = 1, gradient = FALSE, hessian = FALSE)
}
\arguments{
\item{eta}{A numeric vector input}

\item{lambda}{Tuning parameter (a single positive value)}

\item{gradient}{Logical; if \code{TRUE} the output will include a \code{'gradient'} attribute}

\item{hessian}{Logical; if \code{TRUE} the output will include a \code{'hessian'} attribute}

\item{p}{A probability vector (i.e., numeric vector of non-negative values that sum to one)}
}
\value{
Value of the softmax function
}
\description{
\code{softmax} returns the value of the softmax function.
\code{softmaxinv} returns the value of the inverse-softmax function.
}
\details{
The softmax function is a bijective function that maps a real vector with length \code{m-1} to a probability vector
with length \code{m} with all non-zero probabilities.  The softmax function is useful in a wide range of probability
and statistical applications.  The present functions define the softmax function and its inverse, both with a tuning
parameter.
}
\examples{
softmax(5:7)
softmaxinv(softmax(5:7))
}
